/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.google.common.collect.Maps;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.RewardTypeEnum;
import com.handy.playertitle.entity.TitleReward;
import com.handy.playertitle.entity.TitleRewardLog;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.service.TitleRewardLogService;
import com.handy.playertitle.service.TitleRewardService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RewardGui {
    private static final RewardGui INSTANCE = new RewardGui();

    private RewardGui() {
    }

    public static RewardGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.REWARD_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.REWARD_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.REWARD.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.REWARD.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Inventory inventory = handyInventory.getInventory();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.REWARD_CONFIG.getString("reward.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TitleReward> page = TitleRewardService.getInstance().findPage(handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<Object> titleRewardIds = new ArrayList();
        Optional<TitleRewardLog> titleRewardLogOptional = TitleRewardLogService.getInstance().findByPlayerName(player.getName());
        if (titleRewardLogOptional.isPresent() && StrUtil.isNotEmpty(titleRewardLogOptional.get().getRewardIds())) {
            titleRewardIds = StrUtil.strToIntList(titleRewardLogOptional.get().getRewardIds());
        }
        int i = 0;
        boolean isEnchant = ConfigUtil.SHOP_CONFIG.getBoolean("shop.isEnchant");
        String useButton = ConfigUtil.REWARD_CONFIG.getString("useButton");
        String useNotButton = ConfigUtil.REWARD_CONFIG.getString("useNotButton");
        String unableButton = ConfigUtil.REWARD_CONFIG.getString("unableButton");
        block6: for (TitleReward titleReward : page.getRecords()) {
            List<String> loreList = ConfigUtil.REWARD_CONFIG.getStringList("reward.lore");
            Map<String, String> rewardMap = this.getRewardMap(player, titleReward);
            loreList = ItemStackUtil.loreReplaceMap(loreList, rewardMap);
            if (CollUtil.isNotEmpty(titleRewardIds) && titleRewardIds.contains(titleReward.getId())) {
                loreList.add(useButton);
            } else {
                int myTitleNumber = Integer.parseInt(rewardMap.get("myTitleNumber"));
                if (myTitleNumber >= titleReward.getNumber()) {
                    loreList.add(useNotButton);
                } else {
                    loreList.add(unableButton);
                }
            }
            Integer index = indexList.get(i++);
            RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(titleReward.getRewardType());
            switch (rewardTypeEnum) {
                case VAULT: {
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(Material.GOLD_INGOT.name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList, isEnchant));
                    break;
                }
                case PLAYER_POINTS: {
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(Material.DIAMOND.name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList, isEnchant));
                    break;
                }
                case COIN: {
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(Material.EMERALD.name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList, isEnchant));
                    break;
                }
                case ITEM_STACK: {
                    ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleReward.getItemStack());
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(itemStack.getType().name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList, isEnchant));
                    break;
                }
                default: {
                    continue block6;
                }
            }
            map.put(index, titleReward.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, inventory, "open");
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, inventory, "shop");
        HandyInventoryUtil.setCustomButton(ConfigUtil.REWARD_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> getRewardMap(Player player, TitleReward titleReward) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)5);
        map.put("id", titleReward.getId().toString());
        map.put("number", titleReward.getNumber().toString());
        map.put("amount", titleReward.getAmount().toString());
        if (BuyTypeEnum.ITEM_STACK.getBuyType().equals(titleReward.getRewardType())) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleReward.getItemStack());
            map.put("rewardType", BaseUtil.getDisplayName(ItemStackUtil.getItemMeta(itemStack).getDisplayName(), itemStack.getType().toString()));
        } else {
            map.put("rewardType", RewardTypeEnum.getRewardTypeName(titleReward.getRewardType()));
        }
        int count = TitlePlayerService.getInstance().findCount(player.getName());
        map.put("myTitleNumber", Integer.toString(count));
        return map;
    }
}

