/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class TitleParticleService {
    private TitleParticleService() {
    }

    public static TitleParticleService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(TitleParticle titleParticle) {
        this.removeByTitleId(titleParticle.getTitleId());
        return Db.use(TitleParticle.class).execution().insert(titleParticle) > 0;
    }

    public Optional<TitleParticle> findByTitleId(Integer titleId) {
        Db<TitleParticle> use = Db.use(TitleParticle.class);
        use.where().eq(TitleParticle::getTitleId, titleId);
        return use.execution().selectOne();
    }

    public List<TitleParticle> findByTitleIdList(List<Integer> titleIdList) {
        Db<TitleParticle> use = Db.use(TitleParticle.class);
        use.where().in(TitleParticle::getTitleId, titleIdList);
        return use.execution().list();
    }

    public Boolean removeByTitleId(Integer titleId) {
        Db<TitleParticle> use = Db.use(TitleParticle.class);
        use.where().eq(TitleParticle::getTitleId, titleId);
        return use.execution().delete() > 0;
    }

    public boolean removeById(Integer id) {
        return Db.use(TitleParticle.class).execution().deleteById(id) > 0;
    }

    public List<TitleParticle> findAll() {
        return Db.use(TitleParticle.class).execution().list();
    }

    public void removeAll() {
        Db.use(TitleParticle.class).execution().delete();
    }

    private static class SingletonHolder {
        private static final TitleParticleService INSTANCE = new TitleParticleService();

        private SingletonHolder() {
        }
    }
}

