/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.util;

import com.handy.playertitle.constants.BuffType;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.EnabledEffectsNameEnum;
import com.handy.playertitle.constants.ParticleTypeEnum;
import com.handy.playertitle.constants.PotionEffectNameEnum;
import com.handy.playertitle.constants.TabDefaultStylesEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.constants.particle.SuperTrailsEnum;
import com.handy.playertitle.constants.particle.SuperTrailsProEnum;
import com.handy.playertitle.core.BuffManageUtil;
import com.handy.playertitle.core.particle.ParticleManageUtil;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleCoin;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.attribute.MmoParam;
import com.handy.playertitle.lib.attribute.PotionEffectParam;
import com.handy.playertitle.lib.constants.BaseConstants;
import com.handy.playertitle.lib.constants.VersionCheckEnum;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.JsonUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.param.TitleCardParam;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleTabUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class TitleUtil {
    public static List<String> getPotionEffects() {
        PotionEffectType[] values;
        ArrayList<String> potionEffects = new ArrayList<String>();
        for (PotionEffectType potionEffectType : values = PotionEffectType.values()) {
            if (potionEffectType == null) continue;
            String potionEffectTypeName = potionEffectType.getName();
            if ("zh_CN".equals(ConfigUtil.CONFIG.getString("language"))) {
                potionEffectTypeName = potionEffectTypeName + "(" + PotionEffectNameEnum.getPotionEffectName(potionEffectTypeName) + ")";
            }
            potionEffects.add(potionEffectTypeName);
        }
        return potionEffects;
    }

    public static String getTitleCoin(Player player) {
        if (player == null) {
            return "0";
        }
        Optional<TitleCoin> titleCoinOptional = TitleCoinService.getInstance().findByPlayerName(player.getName());
        return titleCoinOptional.map(titleCoin -> titleCoin.getAmount().toString()).orElse("0");
    }

    public static void setPlayerTitle(Player player) {
        TitleUtil.setCache(player);
        BuffManageUtil.getInstance().callBuffEvent(player);
        ParticleManageUtil.setParticle(player);
        TitleTabUtil.setTitleTab(player);
    }

    public static void setPermissionTitle(Player player) {
        List<TitleList> titleLists = TitleListService.getInstance().findAllByBuyType(BuyTypeEnum.PERMISSION.getBuyType());
        if (CollUtil.isEmpty(titleLists)) {
            return;
        }
        Map<Integer, TitleList> titleListMap = titleLists.stream().collect(Collectors.toMap(TitleList::getId, s -> s));
        List<Integer> titleIdList = new ArrayList<Integer>();
        ArrayList<TitlePlayer> titlePlayerList = new ArrayList<TitlePlayer>();
        for (Integer titleId : titleListMap.keySet()) {
            TitleList titleList = titleListMap.get(titleId);
            if (StrUtil.isEmpty(titleList.getItemStack()) || !player.hasPermission(titleList.getItemStack())) continue;
            titleIdList.add(titleList.getId());
        }
        if (CollUtil.isEmpty(titleIdList)) {
            return;
        }
        List<TitlePlayer> titlePlayers = TitlePlayerService.getInstance().findByPlayerNameAndTitleIdList(player.getName(), titleIdList);
        if (CollUtil.isNotEmpty(titlePlayers)) {
            List titleIds = titlePlayers.stream().map(TitlePlayer::getTitleId).collect(Collectors.toList());
            titleIdList = titleIdList.stream().filter(s -> !titleIds.contains(s)).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(titleIdList)) {
            return;
        }
        for (Integer titleId : titleIdList) {
            TitleList titleList = titleListMap.get(titleId);
            TitlePlayer titlePlayer = new TitlePlayer();
            titlePlayer.setPlayerName(player.getName());
            titlePlayer.setPlayerUuid(player.getUniqueId().toString());
            titlePlayer.setTitleId(titleList.getId());
            titlePlayer.setTitleName(titleList.getTitleName());
            titlePlayer.setExpirationTime(DateUtil.getDate(titleList.getDay() != 0 ? titleList.getDay() : 36500));
            titlePlayer.setIsUseShow(false);
            titlePlayer.setIsUseBuff(false);
            titlePlayer.setIsUseParticle(false);
            titlePlayerList.add(titlePlayer);
        }
        TitlePlayerService.getInstance().batchAdd(titlePlayerList);
    }

    public static void playerTitleUse(Player player, Integer titlePlayerId, TitleUseTypeEnum useType, Boolean isAutoUse) {
        Optional<TitlePlayer> titlePlayerOptional = TitlePlayerService.getInstance().findById(titlePlayerId);
        if (!titlePlayerOptional.isPresent()) {
            return;
        }
        TitlePlayer titlePlayer = titlePlayerOptional.get();
        boolean useStatus = TitleUtil.isUse(titlePlayer, useType);
        TitlePlayerService.getInstance().updateUseByPlayer(player.getName(), false, useType);
        if (isAutoUse.booleanValue() || !useStatus) {
            TitlePlayerService.getInstance().updateUseById(titlePlayer.getId(), true, useType);
        }
        TitleUtil.setPlayerTitle(player);
    }

    public static boolean isUse(TitlePlayer titlePlayer, TitleUseTypeEnum useType) {
        if (titlePlayer.getIsUseBuff() == null) {
            titlePlayer.setIsUseBuff(false);
        }
        if (titlePlayer.getIsUseParticle() == null) {
            titlePlayer.setIsUseParticle(false);
        }
        if (titlePlayer.getIsUseShow() == null) {
            titlePlayer.setIsUseShow(false);
        }
        boolean useStatus = false;
        switch (useType) {
            case ALL: {
                if (!titlePlayer.getIsUseShow().booleanValue() && !titlePlayer.getIsUseBuff().booleanValue() && !titlePlayer.getIsUseParticle().booleanValue()) break;
                useStatus = true;
                break;
            }
            case SHOW: {
                useStatus = titlePlayer.getIsUseShow();
                break;
            }
            case BUFF: {
                useStatus = titlePlayer.getIsUseBuff();
                break;
            }
            case PARTICLE: {
                useStatus = titlePlayer.getIsUseParticle();
                break;
            }
        }
        return useStatus;
    }

    public static void setCache(Player player) {
        Optional<TitlePlayer> showOpt = TitlePlayerService.getInstance().findByPlayerNameAndUseType(player.getName(), TitleUseTypeEnum.SHOW);
        Optional<TitlePlayer> buffOpt = TitlePlayerService.getInstance().findByPlayerNameAndUseType(player.getName(), TitleUseTypeEnum.BUFF);
        Optional<TitlePlayer> particleOpt = TitlePlayerService.getInstance().findByPlayerNameAndUseType(player.getName(), TitleUseTypeEnum.PARTICLE);
        TitleConstants.TITLE_PLAYER_SHOW_MAP.put(player.getUniqueId(), showOpt.orElse(null));
        TitleConstants.TITLE_PLAYER_BUFF_MAP.put(player.getUniqueId(), buffOpt.orElse(null));
        TitleConstants.TITLE_PLAYER_PARTICLE_MAP.put(player.getUniqueId(), particleOpt.orElse(null));
        if (!ConfigUtil.SELECT_CONFIG.getBoolean("enable")) {
            TitleConstants.TITLE_PLAYER_BUFF_MAP.putIfAbsent(player.getUniqueId(), showOpt.orElse(null));
            TitleConstants.TITLE_PLAYER_PARTICLE_MAP.putIfAbsent(player.getUniqueId(), particleOpt.orElse(null));
        }
    }

    public static List<String> getParticle(TitleParticle titleParticle) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (titleParticle == null) {
            loreList.add(BaseUtil.getLangMsg("not"));
            return loreList;
        }
        switch (ParticleTypeEnum.getEnum(titleParticle.getParticleType())) {
            case SUPER_TRAILS: {
                loreList.add(SuperTrailsEnum.getName(titleParticle.getSuperTrailsId()));
                break;
            }
            case SUPER_TRAILS_PRO: {
                loreList.add(SuperTrailsProEnum.getName(titleParticle.getSuperTrailsId()));
                break;
            }
            case PLAYER_PARTICLES: {
                loreList.add(EnabledEffectsNameEnum.getZhName(titleParticle.getWingColor()));
                loreList.add(TabDefaultStylesEnum.getZhName(titleParticle.getWingContour()));
                break;
            }
        }
        return loreList;
    }

    public static List<String> getDescription(String description) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (StrUtil.isEmpty(description)) {
            loreList.add(BaseUtil.getLangMsg("not"));
            return loreList;
        }
        loreList.addAll(StrUtil.strToStrList(description));
        return loreList;
    }

    public static boolean isHaveBuff(List<TitleBuff> titleBuffList) {
        boolean rst = false;
        if (CollUtil.isEmpty(titleBuffList)) {
            return false;
        }
        for (TitleBuff titleBuff : titleBuffList) {
            if (BuffType.getType(titleBuff.getBuffType()) == null || StrUtil.isEmpty(titleBuff.getBuffContent())) continue;
            rst = true;
        }
        return rst;
    }

    public static List<String> getBuff(List<TitleBuff> titleBuffList) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (CollUtil.isEmpty(titleBuffList)) {
            loreList.add(BaseUtil.getLangMsg("not"));
            return loreList;
        }
        for (TitleBuff titleBuff : titleBuffList) {
            BuffTypeEnum buffTypeEnum;
            String loreBuff;
            block11: {
                block10: {
                    loreBuff = "";
                    BuffType buffType = BuffType.getType(titleBuff.getBuffType());
                    if (buffType == null || StrUtil.isEmpty(titleBuff.getBuffContent())) continue;
                    buffTypeEnum = BuffTypeEnum.getEnum(titleBuff.getBuffType());
                    if (buffTypeEnum == null) break block10;
                    switch (buffTypeEnum) {
                        case SX_ATTRIBUTE: 
                        case ATTRIBUTE_PLUS: 
                        case ATTRIBUTE_SYSTEM: 
                        case MYTHIC_LIB: {
                            loreBuff = StrUtil.isNotEmpty(titleBuff.getDescription()) ? titleBuff.getDescription() : titleBuff.getBuffContent();
                            break;
                        }
                        case POTION_EFFECT: {
                            PotionEffectParam potionEffectParam = JsonUtil.toBean(titleBuff.getBuffContent(), PotionEffectParam.class);
                            String buffLore = potionEffectParam.getPotionName() + ": " + potionEffectParam.getPotionLevel();
                            if (StrUtil.isNotEmpty(potionEffectParam.getPotionChinesizationName())) {
                                buffLore = potionEffectParam.getPotionChinesizationName() + ": " + potionEffectParam.getPotionLevel();
                            }
                            loreBuff = buffLore;
                            break;
                        }
                        case MMO_ITEMS: {
                            MmoParam mmoParam = JsonUtil.toBean(titleBuff.getBuffContent(), MmoParam.class);
                            if (mmoParam != null && CollUtil.isNotEmpty(mmoParam.getLoreList())) {
                                loreList.addAll(mmoParam.getLoreList());
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block11;
                }
                loreBuff = titleBuff.getBuffContent();
            }
            if (BuffTypeEnum.MMO_ITEMS.equals((Object)buffTypeEnum)) continue;
            loreList.add(loreBuff);
        }
        if (CollUtil.isEmpty(loreList)) {
            loreList.add(BaseUtil.getLangMsg("not"));
            return loreList;
        }
        return loreList;
    }

    public static TitleCardParam getCardData(ItemStack item) {
        Integer id = null;
        Integer day = null;
        Optional<String> jsonOpt = ItemStackUtil.getPersistentData(item, "title_card");
        if (jsonOpt.isPresent()) {
            TitleCardParam titleCardParam = JsonUtil.toBean(jsonOpt.get(), TitleCardParam.class);
            id = titleCardParam.getId();
            day = titleCardParam.getDay();
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId()) {
            Map enchants = ItemStackUtil.getItemMeta(item).getEnchants();
            id = (Integer)enchants.get(Enchantment.DURABILITY);
            day = (Integer)enchants.get(Enchantment.LURE);
        }
        return TitleCardParam.builder().day(day).id(id).build();
    }

    public static void setCardData(ItemMeta itemMeta, Integer id, Integer day) {
        TitleCardParam titleCardParam = TitleCardParam.builder().day(day).id(id).build();
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId()) {
            itemMeta.addEnchant(Enchantment.DURABILITY, id.intValue(), true);
            itemMeta.addEnchant(Enchantment.LURE, day.intValue(), true);
            ItemStackUtil.hideEnchant(itemMeta);
            return;
        }
        ItemStackUtil.setPersistentData(itemMeta, JsonUtil.toJson(titleCardParam), "title_card");
    }
}

