/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.GUI;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.GUI.CMIGUICloseEvent;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIButtonCommand;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Permissions.CMILPerm;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import net.Zrips.CMILib.commands.CMICommand;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GUIManager {
    private HashMap<UUID, CMIGui> map = new HashMap();
    private CMILib plugin;
    private static int MAX_ENTRIES = 50;
    public static LinkedHashMap<UUID, Long> limit = new LinkedHashMap<UUID, Long>(MAX_ENTRIES + 1, 0.75f, false){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, Long> eldest) {
            return this.size() > MAX_ENTRIES;
        }
    };
    public static final String CMIGUIIcon = "CMIGUIIcon";
    public static final String LIProtection = "LIProtection";
    public static boolean usePackets = false;

    public GUIManager(CMILib plugin) {
        this.plugin = plugin;
    }

    public void closeAll() {
        for (Map.Entry<UUID, CMIGui> one : this.map.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)one.getKey());
            if (player == null) continue;
            player.closeInventory();
        }
    }

    public GUIClickType getClickType(boolean left, boolean shift, InventoryAction action, ClickType clickType) {
        if (action != null && action.equals((Object)InventoryAction.CLONE_STACK) || clickType != null && clickType.equals((Object)ClickType.MIDDLE)) {
            return GUIClickType.MiddleMouse;
        }
        if (action != null) {
            if (action.equals((Object)InventoryAction.DROP_ONE_SLOT)) {
                return GUIClickType.Q;
            }
            if (action.equals((Object)InventoryAction.DROP_ALL_SLOT)) {
                return GUIClickType.QControl;
            }
        }
        if (clickType != null) {
            if (clickType.equals((Object)ClickType.LEFT)) {
                return GUIClickType.Left;
            }
            if (clickType.equals((Object)ClickType.SHIFT_LEFT)) {
                return GUIClickType.LeftShift;
            }
            if (clickType.equals((Object)ClickType.RIGHT)) {
                return GUIClickType.Right;
            }
            if (clickType.equals((Object)ClickType.SHIFT_RIGHT)) {
                return GUIClickType.RightShift;
            }
        }
        if (left && !shift) {
            return GUIClickType.Left;
        }
        if (left && shift) {
            return GUIClickType.LeftShift;
        }
        if (!left && !shift) {
            return GUIClickType.Right;
        }
        return GUIClickType.RightShift;
    }

    public boolean processClick(Player player, List<Integer> buttons, GUIClickType clickType) {
        return this.processClick(player, null, buttons, clickType);
    }

    public boolean processClick(Player player, ItemStack currentItem, List<Integer> buttons, GUIClickType clickType) {
        Long time = limit.get(player.getUniqueId());
        if (time != null && time > System.currentTimeMillis()) {
            return false;
        }
        CMIGui gui = this.map.get(player.getUniqueId());
        if (gui == null) {
            return false;
        }
        if (!gui.isAllowMoveAll()) {
            limit.put(player.getUniqueId(), System.currentTimeMillis() + 150L);
        }
        int clicks = 0;
        try {
            if (!gui.getInv().equals(player.getOpenInventory().getTopInventory()) || gui.getInv().getHolder() != null) {
                player.closeInventory();
                this.map.remove(player.getUniqueId());
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Integer one : buttons) {
            CMIGuiButton button = gui.getButtons().get(one);
            if (!gui.click(one, clickType, currentItem)) {
                return false;
            }
            if (button == null) continue;
            ++clicks;
            boolean canClick = true;
            for (String oneC : button.getPermissions()) {
                if (CMILPerm.hasPermission((CommandSender)player, oneC, true, false)) continue;
                canClick = false;
            }
            if (canClick) {
                CMIScheduler.get().runTaskLater(() -> {
                    for (GUIButtonCommand oneC : button.getCommands(clickType)) {
                        CMICommand.performCommand(player, oneC.getCommand(), oneC.getVis());
                    }
                }, 1L);
            }
            button.click();
            button.click(clickType);
            if (button.isCloseInv()) {
                player.closeInventory();
            }
            if (button.getCommands(clickType).isEmpty()) continue;
            break;
        }
        if (clicks == 0) {
            gui.outsideClick(clickType);
        }
        return true;
    }

    public boolean isLockedPart(Player player, List<Integer> buttons) {
        return this.isLockedPart(player, buttons, null);
    }

    public boolean isLockedPart(Player player, List<Integer> buttons, ItemStack item) {
        CMIGui gui = this.map.get(player.getUniqueId());
        if (gui == null) {
            return false;
        }
        int size = gui.getInv().getSize();
        int mainInvMax = size + 36 - 9;
        int quickbar = size + 36;
        boolean itemInHand = item != null && !item.getType().equals((Object)Material.AIR);
        for (Integer one : buttons) {
            if (one > quickbar || quickbar < 0) continue;
            if (one < size && gui.isLocked(InvType.Gui) && gui.isPermLocked(InvType.Gui)) {
                return true;
            }
            if (one < size && gui.isNoItemPlacement(InvType.Gui) && itemInHand) {
                return true;
            }
            if (one >= size && one < mainInvMax && gui.isLocked(InvType.Main) && gui.isPermLocked(InvType.Main)) {
                return true;
            }
            if (one < mainInvMax || one >= quickbar || (!gui.isLocked(InvType.Quickbar) || !gui.isPermLocked(InvType.Quickbar)) && (!gui.isLocked(InvType.Main) || !gui.isPermLocked(InvType.Main))) continue;
            return true;
        }
        return false;
    }

    public boolean canClick(Player player, List<Integer> buttons) {
        return this.canClick(player, buttons, null);
    }

    public boolean canClick(Player player, List<Integer> buttons, ItemStack item) {
        try {
            CMIGui gui = this.map.get(player.getUniqueId());
            if (gui == null) {
                return true;
            }
            boolean itemInHand = item != null && !item.getType().equals((Object)Material.AIR);
            for (Integer one : buttons) {
                CMIGuiButton button = gui.getButtons().get(one);
                if (button == null) continue;
                if (button.getFieldType() == GUIFieldType.Locked) {
                    return false;
                }
                if (!itemInHand || button.getFieldType() != GUIFieldType.noPlacing) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public CMIGui getGui(Player player) {
        return this.map.get(player.getUniqueId());
    }

    public boolean isOpenedGui(Player player) {
        CMIGui gui = this.map.get(player.getUniqueId());
        if (gui == null) {
            return false;
        }
        return player.getOpenInventory() != null;
    }

    public boolean removePlayer(Player player) {
        if (player == null) {
            return false;
        }
        CMIGui removed = this.map.remove(player.getUniqueId());
        if (removed == null) {
            return false;
        }
        if (player.getOpenInventory() != null && player.getOpenInventory().getTopInventory().equals(removed.getInv())) {
            player.closeInventory();
        }
        removed.onClose();
        removed.playCloseSound();
        CMIGUICloseEvent event = new CMIGUICloseEvent(player, removed);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return true;
    }

    public void generateInventory(CMIGui gui) {
        Inventory GuiInv = null;
        GuiInv = gui.getInvSize() != null ? Bukkit.createInventory(null, (int)gui.getInvSize().getFields(), (String)gui.getTitle()) : Bukkit.createInventory(null, (InventoryType)gui.getInvType(), (String)gui.getTitle());
        if (GuiInv == null) {
            return;
        }
        if (!usePackets) {
            for (Map.Entry<Integer, CMIGuiButton> one : gui.getButtons().entrySet()) {
                if (one.getKey() > GuiInv.getSize()) continue;
                try {
                    ItemStack item = one.getValue().getItem(gui.getPlayer());
                    ItemStack itemStack = item = item == null ? null : item.clone();
                    if (item != null && one.getValue().isLocked() && !CMIMaterial.isAir(item.getType())) {
                        item = (ItemStack)new CMINBT(item).setString(CMIGUIIcon, LIProtection);
                    }
                    if (one.getKey() >= GuiInv.getSize()) continue;
                    GuiInv.setItem(one.getKey().intValue(), item);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        gui.setInv(GuiInv);
    }

    public void openGui(CMIGui gui) {
        Player player = gui.getPlayer();
        if (player.isSleeping()) {
            return;
        }
        CMIGui oldGui = null;
        if (this.isOpenedGui(player) && !gui.isSimilar(oldGui = this.plugin.getGUIManager().getGui(player))) {
            oldGui = null;
        }
        if (oldGui == null) {
            this.generateInventory(gui);
            player.closeInventory();
            if (gui.getInv().getHolder() != null) {
                return;
            }
            player.openInventory(gui.getInv());
            if (gui.getInv().getViewers().isEmpty()) {
                return;
            }
            gui.updateButtons();
            gui.playOpenSound();
            gui.onOpen();
            this.map.put(player.getUniqueId(), gui);
        } else {
            this.updateContent(gui);
        }
    }

    private static boolean validInventory(CMIGui gui) {
        Player player = gui.getPlayer();
        return player.getOpenInventory() != null && player.getOpenInventory().getTopInventory() != null && player.getOpenInventory().getTopInventory().getType().equals((Object)gui.getInv().getType()) && player.getOpenInventory().getTopInventory().getSize() == gui.getInv().getSize() && (!Version.isCurrentEqualOrHigher(Version.v1_9_R1) || player.getOpenInventory().getTopInventory().getLocation() == null);
    }

    public void updateContent(CMIGui gui) {
        Player player = gui.getPlayer();
        if (!GUIManager.validInventory(gui)) {
            player.closeInventory();
            this.map.remove(player.getUniqueId());
            return;
        }
        player.getOpenInventory().getTopInventory().setContents(gui.getInv().getContents());
        player.updateInventory();
        gui.setInv(player.getOpenInventory().getTopInventory());
        if (gui.getInv().getHolder() != null) {
            player.closeInventory();
            return;
        }
        gui.updateButtons();
        CMILib.getInstance().getReflectionManager().updateInventoryTitle(player, gui.getTitle());
        this.map.put(player.getUniqueId(), gui);
    }

    public void softUpdateContent(CMIGui gui) {
        Player player = gui.getPlayer();
        if (!GUIManager.validInventory(gui)) {
            player.closeInventory();
            return;
        }
        for (int i = 0; i < player.getOpenInventory().getTopInventory().getSize(); ++i) {
            CMIGuiButton button = gui.getButtons().get(i);
            if (button == null || !button.isLocked()) continue;
            player.getOpenInventory().getTopInventory().setItem(i, button.getItem(gui.getPlayer()));
        }
        gui.setInv(player.getOpenInventory().getTopInventory());
        this.map.put(player.getUniqueId(), gui);
        player.updateInventory();
    }

    public static enum GUIClickType {
        Unknown,
        Left,
        LeftShift,
        Right,
        RightShift,
        MiddleMouse,
        QControl,
        Q;


        public boolean isShiftClick() {
            switch (this) {
                case RightShift: 
                case LeftShift: {
                    return true;
                }
            }
            return false;
        }

        public boolean isLeftClick() {
            switch (this) {
                case LeftShift: 
                case Left: {
                    return true;
                }
            }
            return false;
        }

        public boolean isRightClick() {
            switch (this) {
                case RightShift: 
                case Right: {
                    return true;
                }
            }
            return false;
        }

        public boolean isMiddleClick() {
            switch (this) {
                case MiddleMouse: {
                    return true;
                }
            }
            return false;
        }

        public boolean isQClick() {
            switch (this) {
                case QControl: 
                case Q: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum InvType {
        Gui,
        Main,
        Quickbar;

    }

    public static enum GUIFieldType {
        Free,
        Locked,
        noPlacing;

    }

    public static enum GUIRows {
        r1(1),
        r2(2),
        r3(3),
        r4(4),
        r5(5),
        r6(6);

        private int rows;

        private GUIRows(int rows) {
            this.rows = rows;
        }

        public Integer getFields() {
            return this.rows * 9;
        }

        public Integer getRows() {
            return this.rows;
        }

        public static GUIRows getByRows(Integer rows) {
            if (rows > 9) {
                rows = rows / 9;
            }
            for (GUIRows one : GUIRows.values()) {
                if (!one.getRows().equals(rows)) continue;
                return one;
            }
            return r6;
        }
    }

    public static enum CmiInventoryType {
        regular,
        SavedInv,
        EditableInv,
        RecipeCreator,
        ArmorStandEditor,
        ArmorStandCopy,
        EntityInventoryEditor,
        Recipes,
        SellHand;

    }

    public static enum GUIButtonLocation {
        topLeft(0, 0),
        topRight(0, 1),
        bottomLeft(1, 0),
        bottomRight(1, 1);

        private Integer row;
        private Integer collumn;

        private GUIButtonLocation(Integer row, Integer collumn) {
            this.collumn = collumn;
            this.row = row;
        }

        public Integer getRow() {
            return this.row;
        }

        public Integer getCollumn() {
            return this.collumn;
        }
    }
}

