/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildInfo;
import com.handy.guild.event.GuildDissolutionEvent;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class DissolveCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "dissolve";
    }

    @Override
    public String permission() {
        return "playerGuild.dissolve";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String guildName = args[1];
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByGuildName(guildName);
        if (!guildInfoOptional.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new GuildDissolutionEvent(player, guildInfoOptional.get().getId()));
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
    }
}

