/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildChannel;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.JsonUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandyRunnable;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.BcUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildSpawn;
import com.handy.guild.service.GuildChannelService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Date;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SpawnCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "spawn";
    }

    @Override
    public String permission() {
        return "playerGuild.spawn";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] strings) {
        long keepAlive;
        final Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        final GuildInfo guildInfo = guildInfoOptional.get();
        String spawnLocation = guildInfo.getSpawnLocation();
        if (StrUtil.isEmpty(spawnLocation)) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildSpawnLocationMsg"));
            return;
        }
        final GuildSpawn guildSpawn = JsonUtil.toBean(spawnLocation, GuildSpawn.class);
        String serverName = ConfigUtil.CONFIG.getString("serverName");
        if (StrUtil.isNotEmpty(serverName) && StrUtil.isEmpty(guildSpawn.getServerName())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildSpawnLocationMsg"));
            return;
        }
        long waitTime = ConfigUtil.CONFIG.getLong("waitTime");
        if (GuildConstants.SPAWN_WAIT_TIME.containsKey(player.getUniqueId()) && (keepAlive = (System.currentTimeMillis() - GuildConstants.SPAWN_WAIT_TIME.get(player.getUniqueId())) / 1000L) < waitTime) {
            String waitTimeMsg = BaseUtil.getMsgNotColor("waitTime").replace("${waitTime}", waitTime - keepAlive + "");
            MessageUtil.sendMessage(player, waitTimeMsg);
            return;
        }
        long delayTime = ConfigUtil.CONFIG.getLong("delayTime");
        if (delayTime > 0L) {
            String delayTimeMsg = BaseUtil.getMsgNotColor("delayTime").replace("${delayTime}", delayTime + "");
            MessageUtil.sendMessage(player, delayTimeMsg);
        }
        GuildConstants.SPAWN_TP_WAIT_TIME.put(player.getUniqueId(), false);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                if (GuildConstants.SPAWN_TP_WAIT_TIME.get(player.getUniqueId()) != null && GuildConstants.SPAWN_TP_WAIT_TIME.get(player.getUniqueId()).booleanValue()) {
                    this.cancel();
                    return;
                }
                GuildConstants.SPAWN_TP_WAIT_TIME.remove(player.getUniqueId());
                SpawnCommand.this.spawnTeleport(player, guildSpawn, guildInfo.getGuildName());
            }
        };
        HandySchedulerUtil.runTaskLater(handyRunnable, delayTime * 20L);
    }

    private void spawnTeleport(Player player, GuildSpawn guildSpawn, String guildName) {
        String serverName = ConfigUtil.CONFIG.getString("serverName", "server");
        if (StrUtil.isEmpty(guildSpawn.getServerName()) || serverName.equalsIgnoreCase(guildSpawn.getServerName())) {
            SpawnCommand.teleport(player, guildSpawn, guildName);
            return;
        }
        GuildChannel guildChannel = new GuildChannel();
        guildChannel.setPlayerName(player.getName());
        guildChannel.setPlayerUuid(player.getUniqueId().toString());
        guildChannel.setGuildName(guildName);
        guildChannel.setTpTime(new Date());
        guildChannel.setServerName(guildSpawn.getServerName());
        guildChannel.setSpawnLocation(JsonUtil.toJson(guildSpawn));
        GuildChannelService.getInstance().add(guildChannel);
        BcUtil.tpConnect(player, guildSpawn.getServerName());
    }

    public static void teleport(Player player, GuildSpawn guildSpawn, String guildName) {
        PlayerSchedulerUtil.teleport((Entity)player, GuildUtil.getLocation(guildSpawn));
        MessageUtil.sendTitle(player, guildName, BaseUtil.getMsgNotColor("welcomeTitle").replace("${player}", player.getName()));
        GuildConstants.SPAWN_WAIT_TIME.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

