/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuildCreateWorldGui {
    private static final GuildCreateWorldGui INSTANCE = new GuildCreateWorldGui();

    private GuildCreateWorldGui() {
    }

    public static GuildCreateWorldGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.CREATE_WORLD_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.CREATE_WORLD_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_WORLD_CREATE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_WORLD_CREATE.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_WORLD_CONFIG, inventory, "point", this.replaceMap(handyInventory, "point"));
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_WORLD_CONFIG, inventory, "money", this.replaceMap(handyInventory, "money"));
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_WORLD_CONFIG, inventory, "vault", this.replaceMap(handyInventory, "vault"));
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_WORLD_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(HandyInventory handyInventory, String type) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(3);
        Player player = handyInventory.getPlayer();
        Integer id = handyInventory.getId();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(id);
        if (!guildInfoOptional.isPresent()) {
            return MapUtil.of();
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        String yes = ConfigUtil.CREATE_WORLD_CONFIG.getString("yesButton");
        String button = ConfigUtil.CREATE_WORLD_CONFIG.getString("noButton");
        int price = ConfigUtil.CREATE_WORLD_CONFIG.getInt(type + ".price");
        int money = 0;
        if ("point".equals(type)) {
            int playerPoints;
            money = playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else if ("vault".equals(type)) {
            double playerVault = VaultUtil.getPlayerVault(player);
            money = (int)playerVault;
            if (playerVault >= (double)price) {
                button = yes;
            }
        } else if ("money".equals(type) && (money = guildInfo.getMoney().intValue()) >= price) {
            button = yes;
        }
        map.put("price", String.valueOf(price));
        map.put("money", Integer.toString(money));
        map.put("button", button);
        return map;
    }
}

