/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildTitleGui {
    private static final GuildTitleGui INSTANCE = new GuildTitleGui();

    private GuildTitleGui() {
    }

    public static GuildTitleGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.TITLE_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.TITLE_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_TITLE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_TITLE.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Integer id = handyInventory.getId();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(id);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Integer level = guildInfo.getLevel();
        String nowTitle = ConfigUtil.TITLE_CONFIG.getString(level + ".title", "");
        String nextTitle = ConfigUtil.TITLE_CONFIG.getString(level + 1 + ".title", nowTitle);
        nowTitle = nowTitle.replace("${guild_name}", guildInfo.getGuildName());
        nextTitle = nextTitle.replace("${guild_name}", guildInfo.getGuildName());
        int index = ConfigUtil.TITLE_CONFIG.getInt("now.index");
        String name = ConfigUtil.TITLE_CONFIG.getString("now.name", "${nowTitleName}").replace("${nowTitleName}", nowTitle);
        name = PlaceholderApiUtil.set(player, name);
        String materialStr = ConfigUtil.TITLE_CONFIG.getString("now.material");
        List loreList = ConfigUtil.TITLE_CONFIG.getStringList(level + ".buff");
        List displayList = ConfigUtil.TITLE_CONFIG.getStringList(level + ".display");
        if (CollUtil.isNotEmpty(displayList)) {
            loreList = displayList;
        }
        int customModelDataId = ConfigUtil.TITLE_CONFIG.getInt("now.custom-model-data");
        ItemStack itemStack = ItemStackUtil.getItemStack(materialStr, name, loreList, false, customModelDataId);
        inventory.setItem(index, itemStack);
        int nextIndex = ConfigUtil.TITLE_CONFIG.getInt("next.index");
        String nextName = ConfigUtil.TITLE_CONFIG.getString("next.name", " ${nextTitleName}").replace("${nextTitleName}", nextTitle);
        nextName = PlaceholderApiUtil.set(player, nextName);
        String nextMaterialStr = ConfigUtil.TITLE_CONFIG.getString("next.material");
        List nextLoreList = ConfigUtil.TITLE_CONFIG.getStringList(level + 1 + ".buff");
        if (CollUtil.isEmpty(nextLoreList)) {
            nextLoreList = loreList;
        }
        int nextCustomModelDataId = ConfigUtil.TITLE_CONFIG.getInt("next.custom-model-data");
        ItemStack nextItemStack = ItemStackUtil.getItemStack(nextMaterialStr, nextName, nextLoreList, false, nextCustomModelDataId);
        inventory.setItem(nextIndex, nextItemStack);
        HandyInventoryUtil.setButton(ConfigUtil.TITLE_CONFIG, inventory, "back");
    }
}

