/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.lib.attribute;

import com.google.gson.Gson;
import com.handy.guild.lib.attribute.PotionEffectParam;
import com.handy.guild.lib.constants.BaseConstants;
import com.handy.guild.lib.constants.VersionCheckEnum;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectUtil {
    private PotionEffectUtil() {
    }

    protected static void addAttribute(Player player, List<String> attributeList) {
        ArrayList<PotionEffectParam> peList = new ArrayList<PotionEffectParam>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = (PotionEffectParam)new Gson().fromJson(attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)potionEffectParam.getPotionName());
            if (potionEffectType == null) continue;
            int potionLevel = potionEffectParam.getPotionLevel() - 1;
            if (potionLevel < 0) {
                potionLevel = 0;
            }
            PotionEffect potionEffect = BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId() ? new PotionEffect(potionEffectType, 1728000, potionLevel, false) : new PotionEffect(potionEffectType, 1728000, potionLevel, false, potionEffectParam.getPotionHide() == false);
            potionEffects.add(potionEffect);
        }
        if (!potionEffects.isEmpty()) {
            PlayerSchedulerUtil.addPotionEffects(player, potionEffects);
        }
    }

    protected static void removeAttribute(Player player) {
        Collection activePotionEffects = player.getActivePotionEffects();
        if (activePotionEffects.isEmpty()) {
            return;
        }
        for (PotionEffect potionEffect : activePotionEffects) {
            PotionEffectType potionEffectType;
            if (potionEffect.getDuration() <= 9600 || (potionEffectType = PotionEffectType.getByName((String)"BAD_OMEN")) != null && potionEffectType.equals((Object)potionEffect.getType()) && potionEffect.getDuration() <= 120000) continue;
            PlayerSchedulerUtil.removePotionEffect(player, potionEffect.getType());
        }
    }
}

