/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.command.player.SpawnCommand;
import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.enter.GuildChannel;
import com.handy.guild.enter.GuildNotice;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvp;
import com.handy.guild.hook.PlayerChatUtil;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.JsonUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.HandyHttpUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.lib.util.TextUtil;
import com.handy.guild.param.GuildSpawn;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildChannelService;
import com.handy.guild.service.GuildNoticeReadService;
import com.handy.guild.service.GuildNoticeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import com.handy.guild.util.LeatherUtil;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@HandyListener
public class PlayerJoinEventListener
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        boolean matchRst = this.matchTp(player);
        boolean seasonRst = this.seasonTp(player);
        if (!matchRst && !seasonRst) {
            LeatherUtil.setPlayerItemStack(player);
        }
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                if (ConfigUtil.CONFIG.getBoolean("noGuildRemind", true)) {
                    TextComponent message = new TextComponent(BaseUtil.getLangMsg("noGuildRemind"));
                    message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg open"));
                    MessageUtil.sendMessage(player, message);
                }
                return;
            }
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            GuildConstants.PLAYER_GUILD_MAP.put(player.getUniqueId(), guildPlayer);
            GuildPlayerService.getInstance().updateLastJoinTimeByPlayerName(player.getName(), new Date());
            this.sendNoticeMsg(player, guildPlayer);
            this.sendApplyMsg(player, guildPlayer);
            this.sendSeasonMsg(player, guildPlayer);
            BuffManageUtil.callBuffEvent(player);
            PlayerChatUtil.regPlayerChannel(player, guildPlayer.getGuildInfoId());
        });
    }

    private void sendApplyMsg(Player player, GuildPlayer guildPlayer) {
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            return;
        }
        List<GuildApply> guildApplyList = GuildApplyService.getInstance().findByGuildId(guildPlayer.getGuildInfoId(), ApplyTypeEnum.PENDING.getId());
        for (GuildApply guildApply : guildApplyList) {
            GuildUtil.sendApplyMessage(guildApply.getPlayerName(), guildApply.getId(), player);
        }
    }

    private void sendSeasonMsg(Player player, GuildPlayer guildPlayer) {
        if (!ConfigUtil.ACTIVITY_CONFIG.getBoolean("seasonPvp.enable")) {
            return;
        }
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            return;
        }
        Optional<GuildPvp> guildPvpOptional = GuildPvpService.getInstance().findByGuildInfoId(guildPlayer.getGuildInfoId());
        if (guildPvpOptional.isPresent()) {
            return;
        }
        int startDate = ConfigUtil.ACTIVITY_CONFIG.getInt("seasonPvp.startDate");
        Integer todayWeek = DateUtil.dayOfWeekEnum(new Date());
        if (todayWeek != startDate) {
            TextComponent message = new TextComponent(BaseUtil.getLangMsg("noGuildSeason"));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg me activity "));
            MessageUtil.sendMessage(player, message);
        }
    }

    private void sendNoticeMsg(Player player, GuildPlayer guildPlayer) {
        List<Integer> readNoticeIds = GuildNoticeReadService.getInstance().findGuildNoticeId(guildPlayer.getGuildInfoId(), player.getName());
        List<GuildNotice> list = GuildNoticeService.getInstance().list(guildPlayer.getGuildInfoId(), readNoticeIds);
        if (CollUtil.isNotEmpty(list)) {
            String unreadMsg = ConfigUtil.NOTICE_CONFIG.getString("unreadMsg", "").replace("${size}", String.valueOf(list.size()));
            String lookNotice = ConfigUtil.NOTICE_CONFIG.getString("lookNotice");
            TextComponent textComponent = TextUtil.getInstance().init(unreadMsg).build();
            textComponent.addExtra((BaseComponent)TextUtil.getInstance().init(lookNotice).addClickCommand("/plg me notice").build());
            MessageUtil.sendMessage(player, textComponent);
        }
    }

    private boolean matchTp(Player player) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return false;
        }
        Integer guildId = MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        if (guildId == null) {
            return false;
        }
        Location location = MatchConstants.LOOK_LOCATION.get(guildId);
        if (location == null) {
            PlayerSchedulerUtil.teleport((Entity)player, player.getWorld().getSpawnLocation());
        } else {
            PlayerSchedulerUtil.teleport((Entity)player, location);
        }
        return true;
    }

    private boolean seasonTp(Player player) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return false;
        }
        Integer guildId = SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        if (guildId == null) {
            return false;
        }
        Location location = SeasonConstants.LOOK_LOCATION;
        if (location == null) {
            PlayerSchedulerUtil.teleport((Entity)player, player.getWorld().getSpawnLocation());
        } else {
            PlayerSchedulerUtil.teleport((Entity)player, location);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onOpPlayerJoin(PlayerJoinEvent event) {
        if (!ConfigUtil.CONFIG.getBoolean("isCheckUpdateToOpMsg")) {
            return;
        }
        HandyHttpUtil.checkVersion(event.getPlayer(), "https://api.github.com/repos/handy-git/PlayerGuild/releases/latest");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        HandySchedulerUtil.runTaskLaterAsynchronously(() -> {
            String serverName = ConfigUtil.CONFIG.getString("serverName");
            Optional<GuildChannel> guildChannelOptional = GuildChannelService.getInstance().findByPlayerNameAndServerName(event.getPlayer().getName(), serverName);
            if (!guildChannelOptional.isPresent()) {
                return;
            }
            GuildChannel guildChannel = guildChannelOptional.get();
            GuildChannelService.getInstance().delById(guildChannel.getId());
            HandySchedulerUtil.runTask(() -> SpawnCommand.teleport(event.getPlayer(), JsonUtil.toBean(guildChannel.getSpawnLocation(), GuildSpawn.class), guildChannel.getGuildName()));
        }, 20L);
    }
}

