/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.api.PlayerGuildApi;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;

@HandyListener
public class PlayerRespawnEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        Integer guildId = MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        if (guildId == null) {
            return;
        }
        Location location = MatchConstants.LOOK_LOCATION.get(guildId);
        if (location == null) {
            return;
        }
        event.setRespawnLocation(location);
        MessageUtil.sendMessage(player, ConfigUtil.PVP_LOCATION_CONFIG.getString("lookLocation"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSeasonPlayerRespawn(PlayerRespawnEvent event) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        Integer guildId = SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        if (guildId == null) {
            return;
        }
        Location location = SeasonConstants.LOOK_LOCATION;
        if (location == null) {
            return;
        }
        event.setRespawnLocation(location);
        MessageUtil.sendMessage(player, ConfigUtil.PVP_LOCATION_CONFIG.getString("lookLocation"));
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (PlayerGuildApi.getInstance().isPvp(player)) {
            return;
        }
        BuffManageUtil.callBuffEvent(player);
    }
}

