/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.inventory.GuildInvitationGui;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildInvitationClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_INVITATION.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Object> map = handyInventory.getObjMap();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.INVITATION_CONFIG, "back")) {
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.INVITATION_CONFIG, "previousPage")) {
            if (pageNum <= 1) return;
            handyInventory.setPageNum(handyInventory.getPageNum() - 1);
            GuildInvitationGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.INVITATION_CONFIG, "nextPage")) {
            if (pageNum + 1 > pageCount) return;
            handyInventory.setPageNum(handyInventory.getPageNum() + 1);
            GuildInvitationGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Object playerName = map.get(rawSlot);
        if (playerName == null) {
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        int price = ConfigUtil.INVITATION_CONFIG.getInt("member.price");
        if (guildInfo.getMoney() < price) {
            MessageUtil.sendMessage(player, ConfigUtil.INVITATION_CONFIG.getString("member.noButton"));
            return;
        }
        List<Integer> guildIdList = GuildConstants.INVITATION_PLAYER_MAP.get(playerName.toString());
        if (CollUtil.isNotEmpty(guildIdList)) {
            if (guildIdList.contains(guildInfo.getId())) return;
            guildIdList.add(guildInfo.getId());
            GuildInfoService.getInstance().subtractMoneyById(guildId, price);
        } else {
            guildIdList = new ArrayList<Integer>();
            guildIdList.add(guildInfo.getId());
            GuildConstants.INVITATION_PLAYER_MAP.put(playerName.toString(), guildIdList);
            GuildInfoService.getInstance().subtractMoneyById(guildId, price);
        }
        GuildUtil.sendInvitationMessage(player.getName(), guildInfo, playerName.toString());
        GuildInvitationGui.getInstance().setInventoryDate(handyInventory);
    }
}

