/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildBuff;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPlayerPickaxe;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.inventory.GuildSacredStoneGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.FormulaUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.HandyConfigUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildBuffService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerPickaxeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildSacredStoneClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_SACRED_STONE.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SACRED_STONE_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SACRED_STONE_CONFIG, "info")) {
            this.up(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SACRED_STONE_CONFIG, "woodenPickaxe")) {
            this.pickaxe("woodenPickaxe", handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SACRED_STONE_CONFIG, "ironPickaxe")) {
            this.pickaxe("ironPickaxe", handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SACRED_STONE_CONFIG, "goldenPickaxe")) {
            this.pickaxe("goldenPickaxe", handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SACRED_STONE_CONFIG, "diamondPickaxe")) {
            this.pickaxe("diamondPickaxe", handyInventory);
            return;
        }
        Map<String, Object> buffMap = HandyConfigUtil.getChildMap(ConfigUtil.SACRED_STONE_CONFIG, "buff");
        for (String type : buffMap.keySet()) {
            int buffIndex = ConfigUtil.SACRED_STONE_CONFIG.getInt("buff." + type + ".index");
            if (rawSlot != buffIndex) continue;
            this.lock(type, handyInventory);
            return;
        }
    }

    private synchronized void lock(String type, HandyInventory handyInventory) {
        int maxLevel;
        Integer guildId = handyInventory.getId();
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.ONE.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Map<String, GuildBuff> buffMap = GuildBuffService.getInstance().findByGuildId(guildId);
        int level = buffMap.get(type) != null ? buffMap.get(type).getLevel() + 1 : 1;
        if (level > (maxLevel = ConfigUtil.SACRED_STONE_CONFIG.getInt("buff." + type + ".maxLevel"))) {
            MessageUtil.sendMessage(player, ConfigUtil.SACRED_STONE_CONFIG.getString("maxLevelMsg"));
            return;
        }
        String nextPrice = ConfigUtil.SACRED_STONE_CONFIG.getString("buff." + type + ".price");
        nextPrice = PlaceholderApiUtil.set(player, nextPrice);
        Integer price = FormulaUtil.evaluateFormulaToInt(nextPrice, MapUtil.of("level", String.valueOf(level)));
        if (guildInfo.getOre() < price) {
            MessageUtil.sendMessage(player, ConfigUtil.SACRED_STONE_CONFIG.getString("noOre"));
            return;
        }
        GuildBuff guildBuff = buffMap.get(type);
        if (guildBuff == null) {
            guildBuff = new GuildBuff();
            guildBuff.setGuildInfoId(guildId);
            guildBuff.setBuffType(type);
            guildBuff.setLevel(1);
            GuildBuffService.getInstance().add(guildBuff);
        } else {
            GuildBuffService.getInstance().addLevelById(guildBuff.getId(), 1);
        }
        GuildInfoService.getInstance().subtractOreById(guildId, price);
        GuildSacredStoneGui.getInstance().setInventoryDate(handyInventory);
        BuffManageUtil.refreshCallBuffEvent(guildId);
    }

    private synchronized void up(HandyInventory handyInventory) {
        Integer guildId = handyInventory.getId();
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Integer sacredStoneLevel = guildInfo.getSacredStoneLevel();
        Integer money = guildInfo.getMoney();
        int nextPrice = ConfigUtil.SACRED_STONE_CONFIG.getInt(sacredStoneLevel + 1 + ".price", -1);
        if (nextPrice == -1) {
            MessageUtil.sendMessage(player, ConfigUtil.SACRED_STONE_CONFIG.getString("maxButton"));
            return;
        }
        if (money < nextPrice) {
            MessageUtil.sendMessage(player, ConfigUtil.SACRED_STONE_CONFIG.getString("noButton"));
            return;
        }
        GuildInfoService.getInstance().subtractMoneyById(guildId, nextPrice);
        GuildInfoService.getInstance().addSacredStoneLevelById(guildId, 1);
        MessageUtil.sendMessage(player, ConfigUtil.SACRED_STONE_CONFIG.getString("succeedMsg"));
        GuildSacredStoneGui.getInstance().setInventoryDate(handyInventory);
    }

    private synchronized void pickaxe(String type, HandyInventory handyInventory) {
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getPickaxeTime() != null) {
            String pickaxeTime = DateUtil.format(guildPlayer.getPickaxeTime(), "yyyy-MM-dd");
            if (DateUtil.format(new Date(), "yyyy-MM-dd").equalsIgnoreCase(pickaxeTime)) {
                return;
            }
        }
        int price = ConfigUtil.SACRED_STONE_CONFIG.getInt(type + ".price", 0);
        if (guildPlayer.getMoney() < price) {
            String notMoneyExcavated = ConfigUtil.SACRED_STONE_CONFIG.getString("notMoneyExcavated");
            MessageUtil.sendMessage(player, notMoneyExcavated);
            return;
        }
        GuildPlayerService.getInstance().subtractMoneyById(guildPlayer.getId(), price);
        this.rewards(type, guildPlayer, player);
        GuildSacredStoneGui.getInstance().setInventoryDate(handyInventory);
    }

    private void rewards(String type, GuildPlayer guildPlayer, Player player) {
        Date date = new Date();
        String ore = ConfigUtil.SACRED_STONE_CONFIG.getString(type + ".ore", "");
        List<Integer> oreList = StrUtil.strToIntList(ore);
        int rewards = new Random().nextInt(oreList.get(1) - oreList.get(0) + 1) + oreList.get(0);
        GuildPlayerService.getInstance().setPickaxeTime(guildPlayer.getPlayerName(), date, rewards);
        GuildPlayerPickaxe guildPlayerPickaxe = new GuildPlayerPickaxe();
        guildPlayerPickaxe.setGuildInfoId(guildPlayer.getGuildInfoId());
        guildPlayerPickaxe.setPlayerName(guildPlayer.getPlayerName());
        guildPlayerPickaxe.setPlayerUuid(guildPlayer.getPlayerUuid());
        guildPlayerPickaxe.setPickaxeTime(date);
        guildPlayerPickaxe.setType(type);
        guildPlayerPickaxe.setRewards(rewards);
        GuildPlayerPickaxeService.getInstance().add(guildPlayerPickaxe);
        GuildInfoService.getInstance().addOreById(guildPlayer.getGuildInfoId(), rewards);
        String excavationSuccess = ConfigUtil.SACRED_STONE_CONFIG.getString("excavationSuccess", "");
        excavationSuccess = excavationSuccess.replace("${ore}", String.valueOf(rewards));
        MessageUtil.sendMessage(player, excavationSuccess);
    }
}

