/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.inventory.GuildSelectLocationGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class GuildSelectLocationClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_SELECT_LOCATION.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> intMap = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.PVP_LOCATION_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildSelectLocationGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.PVP_LOCATION_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildSelectLocationGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.PVP_LOCATION_CONFIG, "random")) {
            MessageUtil.sendMessage(player, ConfigUtil.PVP_LOCATION_CONFIG.getString("ramDonLocation"));
            handyInventory.syncClose();
            return;
        }
        Integer id = intMap.get(rawSlot);
        if (id == null) {
            return;
        }
        ArrayList<Integer> haveIdList = new ArrayList<Integer>();
        for (Integer guildId : MatchConstants.GUILD_PVP_START_LOCATION_MAP.keySet()) {
            haveIdList.add(MatchConstants.GUILD_PVP_START_LOCATION_MAP.get(guildId));
        }
        if (haveIdList.contains(id)) {
            return;
        }
        Optional<GuildPvpLocation> guildPvpLocationOptional = GuildPvpLocationService.getInstance().findById(id);
        if (!guildPvpLocationOptional.isPresent()) {
            return;
        }
        GuildPvpLocation guildPvpLocation = guildPvpLocationOptional.get();
        MatchConstants.GUILD_PVP_PREPARATION_LOCATION_MAP.put(player.getUniqueId(), id);
        MessageUtil.sendMessage(player, ConfigUtil.PVP_LOCATION_CONFIG.getString("selYesLocation", "").replace("${location}", BaseUtil.replaceChatColor(guildPvpLocation.getName())));
        handyInventory.syncClose();
    }
}

