/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.command.function.UpCommand;
import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.inventory.ConfirmGui;
import com.handy.guild.inventory.GuildApplyGui;
import com.handy.guild.inventory.GuildCreateWorldGui;
import com.handy.guild.inventory.GuildInvitationGui;
import com.handy.guild.inventory.GuildLogoOpenGui;
import com.handy.guild.inventory.GuildLogoShopGui;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildSettingClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_SETTING.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "up")) {
            UpCommand.up(player);
            GuildSettingGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "editName")) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            int price = ConfigUtil.SETTING_CONFIG.getInt("editName.price");
            if (guildInfo.getMoney() < price) {
                MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("editName.noButton"));
                return;
            }
            GuildConstants.CREATE_GUILD_INFO_MAP.put(player.getUniqueId(), "edit");
            handyInventory.syncClose();
            MessageUtil.sendMessage(player, ConfigUtil.OPEN_CONFIG.getString("create.nameMsg"));
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "invitation")) {
            Inventory inventory = GuildInvitationGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "logoShop")) {
            Inventory inventory = GuildLogoShopGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "logoWarehouse")) {
            Inventory inventory = GuildLogoOpenGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "apply")) {
            Inventory inventory = GuildApplyGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "pvp")) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            int price = ConfigUtil.SETTING_CONFIG.getInt("pvp.price");
            if (guildInfo.getMoney() < price) {
                MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("editName.noButton"));
                return;
            }
            GuildInfoService.getInstance().editPlayerPvpStatus(guildId, guildInfo.getPvpStatus() == false, price);
            GuildSettingGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "setSpawn")) {
            PlayerSchedulerUtil.syncPerformCommand(player, "plg setSpawn");
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "createGuildWorld")) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            if (StrUtil.isNotEmpty(guildInfo.getWorldName())) {
                World world = Bukkit.getWorld((String)guildInfo.getWorldName());
                if (world == null) {
                    MessageUtil.sendMessage(player, BaseUtil.getLangMsg("noGuildWorld"));
                    return;
                }
                Location spawnLocation = WorldUtil.getSpawnLocation(guildInfo.getWorldName());
                PlayerSchedulerUtil.syncTeleport((Entity)player, spawnLocation);
                return;
            }
            GuildPlayer guildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId());
            if (!GuildRoleEnum.ONE.getRoleId().equals(guildPlayer.getRoleId())) {
                MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
                return;
            }
            Inventory inventory = GuildCreateWorldGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "dissolution")) {
            Inventory inventory = ConfirmGui.getInstance().createGui(player, guildId, "dissolution", null);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "description")) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            int price = ConfigUtil.SETTING_CONFIG.getInt("description.price");
            if (guildInfo.getMoney() < price) {
                MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("description.noButton"));
                return;
            }
            GuildConstants.CREATE_GUILD_INFO_MAP.put(player.getUniqueId(), "editDescription");
            handyInventory.syncClose();
            MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("description.changDescription"));
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "joinMode")) {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
            if (!guildInfoOptional.isPresent()) {
                return;
            }
            GuildInfo guildInfo = guildInfoOptional.get();
            int price = ConfigUtil.SETTING_CONFIG.getInt("joinMode.price");
            if (guildInfo.getMoney() < price) {
                MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("editName.noButton"));
                return;
            }
            boolean joinMode = guildInfo.getJoinMode() != null && guildInfo.getJoinMode() == false;
            GuildInfoService.getInstance().editJoinMode(guildId, joinMode, price);
            GuildSettingGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SETTING_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
        }
    }
}

