/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.season;

import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildEquipment;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.enter.GuildSpawnPvpLocation;
import com.handy.guild.event.GuildSeasonPvpStartEvent;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildSeasonPvpPlayerParam;
import com.handy.guild.service.GuildEquipmentService;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.service.GuildSpawnPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import com.handy.guild.util.KitPvpUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@HandyListener
public class GuildSeasonPvpStartEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onGuildSeasonPvpStartEvent(GuildSeasonPvpStartEvent event) {
        List<Integer> guildIdList = event.getGuildIdList();
        List<GuildPvpLocation> seasonLocationList = GuildPvpLocationService.getInstance().findByType(GuildActivityType.SEASON.getType());
        if (CollUtil.isEmpty(seasonLocationList)) {
            MessageUtil.sendAllMessage(ConfigUtil.PVP_LOCATION_CONFIG.getString("noSeasonLocation"));
            return;
        }
        GuildPvpLocation guildPvpLocation = seasonLocationList.get(new Random().nextInt(seasonLocationList.size()));
        MessageUtil.sendConsoleMessage("\u7b2c" + event.getSeason() + "\u8d5b\u5b63\u516c\u4f1a\u6218\u5f00\u59cb,\u672c\u6b21\u968f\u673a\u53c2\u8d5b\u573a\u5730:" + guildPvpLocation.getName());
        List<GuildSpawnPvpLocation> spawnList = GuildSpawnPvpLocationService.getInstance().list(guildPvpLocation.getId());
        String lookLocationName = ConfigUtil.ACTIVITY_CONFIG.getString("season.lookLocation");
        for (GuildSpawnPvpLocation guildSpawnPvpLocation : spawnList) {
            if (!guildSpawnPvpLocation.getSpawnName().equalsIgnoreCase(lookLocationName)) continue;
            SeasonConstants.LOOK_LOCATION = GuildUtil.getLocation(guildSpawnPvpLocation);
            break;
        }
        List guildSpawnPvpLocationList = spawnList.stream().filter(s -> !s.getSpawnName().equalsIgnoreCase(lookLocationName)).collect(Collectors.toList());
        HashMap<Integer, GuildSpawnPvpLocation> guildSpawnPvpLocationMap = MapUtil.newHashMapWithExpectedSize(guildSpawnPvpLocationList.size());
        for (int i = 0; i < guildSpawnPvpLocationList.size(); ++i) {
            guildSpawnPvpLocationMap.put(i, (GuildSpawnPvpLocation)guildSpawnPvpLocationList.get(i));
        }
        for (Integer guildId : guildIdList) {
            List uuidList = SeasonConstants.GUILD_PVP_PREPARATION_MAP.getOrDefault(guildId, new ArrayList());
            ArrayList<GuildSeasonPvpPlayerParam> pvpPlayerParamList = new ArrayList<GuildSeasonPvpPlayerParam>();
            for (UUID uuid : uuidList) {
                Player guildOnlinePlayer;
                Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(uuid);
                if (!onlinePlayerOpt.isPresent() || (guildOnlinePlayer = onlinePlayerOpt.get()).isDead()) continue;
                GuildSeasonPvpPlayerParam param = new GuildSeasonPvpPlayerParam();
                param.setMeGuildId(guildId);
                param.setPlayerName(guildOnlinePlayer.getName());
                param.setPlayerUuid(uuid);
                param.setKill(0);
                param.setSeason(event.getSeason());
                param.setIsDeath(false);
                pvpPlayerParamList.add(param);
                SeasonConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.put(uuid, guildOnlinePlayer.getLocation());
            }
            SeasonConstants.GUILD_PVP_START_PLAYER_MAP.put(guildId, pvpPlayerParamList);
            SeasonConstants.GUILD_PVP_PREPARATION_MAP.remove(guildId);
        }
        for (Integer guildId : guildIdList) {
            if (!CollUtil.isEmpty((Collection)SeasonConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId))) continue;
            SeasonConstants.GUILD_PVP_START_PLAYER_MAP.remove(guildId);
        }
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.size() < 2) {
            MessageUtil.sendAllMessage(ConfigUtil.ACTIVITY_CONFIG.getString("season.noPlayer"));
            SeasonConstants.GUILD_PVP_START_PLAYER_MAP.clear();
            return;
        }
        SeasonConstants.START_TIME = new Date();
        int locationNumber = 0;
        int i = 0;
        Map<Integer, Color> colorMap = GuildUtil.getColorMap();
        List<GuildEquipment> guildEquipments = GuildEquipmentService.getInstance().findAll();
        for (Integer guildId : SeasonConstants.GUILD_PVP_START_PLAYER_MAP.keySet()) {
            Chunk chunkAt;
            Location location;
            World world;
            GuildSpawnPvpLocation guildSpawnPvpLocation;
            if ((guildSpawnPvpLocation = (GuildSpawnPvpLocation)guildSpawnPvpLocationMap.get(locationNumber++)) == null) {
                locationNumber = 0;
                guildSpawnPvpLocation = (GuildSpawnPvpLocation)guildSpawnPvpLocationMap.get(locationNumber++);
            }
            if ((world = (location = GuildUtil.getLocation(guildSpawnPvpLocation)).getWorld()) != null && !(chunkAt = world.getChunkAt(location)).isLoaded()) {
                chunkAt.load();
            }
            List<GuildSeasonPvpPlayerParam> pvpPlayerParams = SeasonConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
            Color color = colorMap.get(i++);
            for (GuildSeasonPvpPlayerParam param : pvpPlayerParams) {
                Optional<Player> guildOnlinePlayerOpt = BaseUtil.getOnlinePlayer(param.getPlayerUuid());
                if (!guildOnlinePlayerOpt.isPresent()) continue;
                Player guildOnlinePlayer = guildOnlinePlayerOpt.get();
                PlayerSchedulerUtil.teleport((Entity)guildOnlinePlayer, location);
                KitPvpUtil.kitPvp(guildOnlinePlayer);
                if (color == null) {
                    color = Color.RED;
                }
                KitPvpUtil.equipment(guildOnlinePlayer, color, guildEquipments);
                SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.put(param.getPlayerUuid(), param.getMeGuildId());
            }
        }
    }
}

