/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import java.util.List;
import java.util.Optional;

public class GuildApplyService {
    private GuildApplyService() {
    }

    public static GuildApplyService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildApply guildApply) {
        return Db.use(GuildApply.class).execution().insert(guildApply);
    }

    public Optional<GuildApply> findById(Integer id) {
        return Db.use(GuildApply.class).execution().selectById(id);
    }

    public List<GuildApply> findByGuildId(Integer guildId, Integer applyResult) {
        Db<GuildApply> db = Db.use(GuildApply.class);
        db.where().eq(GuildApply::getGuildInfoId, guildId).eq(applyResult != null, GuildApply::getApplyResult, applyResult);
        return db.execution().list();
    }

    public Optional<GuildApply> findByPlayerName(String playerName, Integer applyResult) {
        Db<GuildApply> db = Db.use(GuildApply.class);
        db.where().eq(StrUtil.isNotEmpty(playerName), GuildApply::getPlayerName, playerName).eq(applyResult != null, GuildApply::getApplyResult, applyResult);
        return db.execution().selectOne();
    }

    public void updateById(GuildApply guildApply) {
        Db<GuildApply> guildApplyDenyDb = Db.use(GuildApply.class);
        guildApplyDenyDb.update().set(GuildApply::getApplyResult, guildApply.getApplyResult()).set(GuildApply::getApplyPlayerName, guildApply.getApplyPlayerName()).set(GuildApply::getApplyPlayerUuid, guildApply.getApplyPlayerUuid());
        guildApplyDenyDb.execution().updateById(guildApply.getId());
    }

    public void updateApplyResultByPlayerName(String playerName, Integer applyResult) {
        Db<GuildApply> db = Db.use(GuildApply.class);
        db.update().set(GuildApply::getApplyResult, applyResult);
        db.where().eq(GuildApply::getApplyResult, ApplyTypeEnum.PENDING.getId()).eq(GuildApply::getPlayerName, playerName);
        db.execution().update();
    }

    public Page<GuildApply> page(Integer guildInfoId, Integer pageNum, Integer pageSize, Integer applyResult) {
        Db<GuildApply> db = Db.use(GuildApply.class);
        db.where().eq(GuildApply::getGuildInfoId, guildInfoId).eq(GuildApply::getApplyResult, applyResult).limit(pageNum, pageSize).orderByDesc(GuildApply::getApplyTime);
        return db.execution().page();
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildApply> use = Db.use(GuildApply.class);
        use.where().eq(GuildApply::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildApply> findAll() {
        return Db.use(GuildApply.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildApplyService INSTANCE = new GuildApplyService();

        private SingletonHolder() {
        }
    }
}

