/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import java.util.List;
import java.util.Optional;

public class GuildLogoShopService {
    private GuildLogoShopService() {
    }

    public static GuildLogoShopService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildLogoShop guildLogoShop) {
        return Db.use(GuildLogoShop.class).execution().insert(guildLogoShop);
    }

    public Page<GuildLogoShop> page(List<Integer> notIds, Integer pageNum, Integer pageSize) {
        Db<GuildLogoShop> db = Db.use(GuildLogoShop.class);
        db.where().notIn(CollUtil.isNotEmpty(notIds), GuildLogoShop::getId, notIds).eq(GuildLogoShop::getDefaultLogoFlag, 0).limit(pageNum, pageSize).orderByDesc(GuildLogoShop::getId);
        return db.execution().page();
    }

    public void delById(Integer id) {
        Db.use(GuildLogoShop.class).execution().deleteById(id);
    }

    public Optional<GuildLogoShop> findById(Integer id) {
        return Db.use(GuildLogoShop.class).execution().selectById(id);
    }

    public List<GuildLogoShop> findAll() {
        return Db.use(GuildLogoShop.class).execution().list();
    }

    public void updateLogoName(Integer id, String logoName) {
        Db<GuildLogoShop> use = Db.use(GuildLogoShop.class);
        use.update().set(GuildLogoShop::getItemStack, logoName);
        use.execution().updateById(id);
    }

    public int update(GuildLogoShop guildLogoShop) {
        Db<GuildLogoShop> use = Db.use(GuildLogoShop.class);
        use.update().set(GuildLogoShop::getLevel, guildLogoShop.getLevel()).set(GuildLogoShop::getPrice, guildLogoShop.getPrice()).set(GuildLogoShop::getItemStack, guildLogoShop.getItemStack());
        return use.execution().updateById(guildLogoShop.getId());
    }

    public Optional<GuildLogoShop> findDefaultLogo(Integer level) {
        Db<GuildLogoShop> db = Db.use(GuildLogoShop.class);
        db.where().eq(GuildLogoShop::getDefaultLogoFlag, 1).eq(GuildLogoShop::getLevel, level);
        return db.execution().selectOne();
    }

    private static class SingletonHolder {
        private static final GuildLogoShopService INSTANCE = new GuildLogoShopService();

        private SingletonHolder() {
        }
    }
}

