/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildPlayerCooling;
import com.handy.guild.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class GuildPlayerCoolingService {
    private GuildPlayerCoolingService() {
    }

    public static GuildPlayerCoolingService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildPlayerCooling guildPlayerCooling) {
        Db.use(GuildPlayerCooling.class).execution().insert(guildPlayerCooling);
    }

    public Optional<GuildPlayerCooling> findByPlayerName(String playerName) {
        Db<GuildPlayerCooling> playerDb = Db.use(GuildPlayerCooling.class);
        playerDb.where().eq(GuildPlayerCooling::getPlayerName, playerName);
        return playerDb.execution().selectOne();
    }

    public void delByPlayerName(String playerName) {
        Db<GuildPlayerCooling> use = Db.use(GuildPlayerCooling.class);
        use.where().eq(GuildPlayerCooling::getPlayerName, playerName);
        use.execution().delete();
    }

    public List<GuildPlayerCooling> findAll() {
        return Db.use(GuildPlayerCooling.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPlayerCoolingService INSTANCE = new GuildPlayerCoolingService();

        private SingletonHolder() {
        }
    }
}

