/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildTask;
import com.handy.guild.enter.GuildTaskDemand;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.db.Db;
import java.util.List;

public class GuildTaskDemandService {
    private GuildTaskDemandService() {
    }

    public static GuildTaskDemandService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildTaskDemand guildTaskDemand) {
        Db.use(GuildTaskDemand.class).execution().insert(guildTaskDemand);
    }

    public List<GuildTaskDemand> findByGuildIdAndContent(Integer guildId, String content, String demandType) {
        Db<GuildTaskDemand> use = Db.use(GuildTaskDemand.class);
        use.where().eq(GuildTaskDemand::getGuildInfoId, guildId).eq(GuildTaskDemand::getItemStack, content).eq(GuildTaskDemand::getType, demandType).lt(GuildTaskDemand::getCompletionAmount, GuildTaskDemand::getAmount).ge(GuildTask::getStartDate, DateUtil.getMonday()).le(GuildTask::getEndDate, DateUtil.getSunday());
        return use.execution().list();
    }

    public void updateCompletionAmount(Integer id, Integer completionAmount) {
        Db<GuildTaskDemand> use = Db.use(GuildTaskDemand.class);
        use.update().add(GuildTaskDemand::getCompletionAmount, GuildTaskDemand::getCompletionAmount, completionAmount);
        use.execution().updateById(id);
    }

    public Boolean findCountByGuildTaskId(Integer guildTaskId) {
        Db<GuildTaskDemand> use = Db.use(GuildTaskDemand.class);
        use.where().eq(GuildTaskDemand::getGuildTaskId, guildTaskId).lt(GuildTaskDemand::getCompletionAmount, GuildTaskDemand::getAmount);
        return use.execution().count() > 0;
    }

    public List<GuildTaskDemand> findByGuildTaskIds(List<Integer> guildTaskIdList) {
        Db<GuildTaskDemand> use = Db.use(GuildTaskDemand.class);
        use.where().in(GuildTaskDemand::getGuildTaskId, guildTaskIdList);
        return use.execution().list();
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildTaskDemand> use = Db.use(GuildTaskDemand.class);
        use.where().eq(GuildTaskDemand::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildTaskDemand> findAll() {
        return Db.use(GuildTaskDemand.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildTaskDemandService INSTANCE = new GuildTaskDemandService();

        private SingletonHolder() {
        }
    }
}

