/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskCoinService;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CoinCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "coin";
    }

    @Override
    public String permission() {
        return "playerTask.coin";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        boolean rst;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(args[2]);
        TaskCoinService.getInstance().init(offlinePlayer);
        switch (args[1].toLowerCase()) {
            case "give": {
                rst = TaskCoinService.getInstance().addCoin(offlinePlayer.getUniqueId(), amount);
                break;
            }
            case "set": {
                rst = TaskCoinService.getInstance().set(offlinePlayer.getUniqueId(), amount);
                break;
            }
            case "take": {
                rst = TaskCoinService.getInstance().subtractCoin(offlinePlayer.getUniqueId(), amount);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                return;
            }
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

