/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.inventory.CreateDemandGui;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.service.TaskListService;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "edit";
    }

    @Override
    public String permission() {
        return "playerTask.edit";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Integer taskId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Optional<TaskList> taskListOptional = TaskListService.getInstance().findById(taskId);
        AssertUtil.isTrue(taskListOptional.isPresent(), sender, BaseUtil.getMsgNotColor("noDataExist"));
        TaskList taskList = taskListOptional.get();
        BaseTaskConstants.TASK_LIST_MAP.put(player.getUniqueId(), taskList);
        player.openInventory(CreateDemandGui.getInstance().createGui(player, DemandTypeEnum.ALL.getType()));
    }
}

