/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.constants;

import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.HandyPermissionUtil;
import com.handy.playertask.lib.util.LotteryUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.util.ConfigUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public enum RarityEnum {
    ALL("all", -1),
    NORMAL("normal", 0),
    ADVANCED("advanced", 1),
    RARE("rare", 2),
    RARER("rarer", 3),
    EPIC("epic", 4),
    MYTHICAL("mythical", 5);

    private final String type;
    private final Integer index;

    public static Map<String, Integer> getTypeMap(Player player, int num) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        ArrayList<Double> probabilityList = new ArrayList<Double>();
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (ALL.equals((Object)rarityEnum)) continue;
            Double permissionNumber = HandyPermissionUtil.getDoubleNumber(player, ConfigUtil.CONFIG, "rarity." + rarityEnum.getType());
            probabilityList.add(permissionNumber);
        }
        LotteryUtil lotteryUtil = new LotteryUtil(probabilityList);
        for (int i = 0; i < num; ++i) {
            String type = RarityEnum.getByIndex(lotteryUtil.randomIndex()).getType();
            map.merge(type, 1, Integer::sum);
        }
        for (String rarity : map.keySet()) {
            MessageUtil.sendConsoleDebugMessage("\u4eca\u65e5\u4efb\u52a1\u62bd\u53d6,\u7c7b\u578b:" + BaseUtil.getMsgNotColor("rarity." + rarity) + ",\u6570\u91cf:" + map.get(rarity));
        }
        return map;
    }

    public static RarityEnum getByIndex(Integer index) {
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (!rarityEnum.getIndex().equals(index)) continue;
            return rarityEnum;
        }
        return NORMAL;
    }

    public static List<String> getTabEnum() {
        ArrayList<String> enumList = new ArrayList<String>();
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (ALL.equals((Object)rarityEnum)) continue;
            enumList.add(rarityEnum.getType());
        }
        return enumList;
    }

    public static RarityEnum getEnum(String type) {
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (!rarityEnum.getType().equalsIgnoreCase(type)) continue;
            return rarityEnum;
        }
        return NORMAL;
    }

    public static RarityEnum getNextEnum(String name) {
        RarityEnum anEnum = RarityEnum.getEnum(name);
        int num = anEnum.getIndex() + 1;
        if (num > 5) {
            num = -1;
        }
        for (RarityEnum rarityEnum : RarityEnum.values()) {
            if (rarityEnum.getIndex() != num) continue;
            return rarityEnum;
        }
        return NORMAL;
    }

    public static String getEnumName(String type) {
        return BaseUtil.getMsgNotColor("rarity." + type);
    }

    public String getType() {
        return this.type;
    }

    public Integer getIndex() {
        return this.index;
    }

    private RarityEnum(String type, Integer index) {
        this.type = type;
        this.index = index;
    }
}

