/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib.util;

import com.handy.playertask.lib.InitApi;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HandyPermissionUtil {
    private HandyPermissionUtil() {
    }

    public static Double getDoubleNumber(Player player, FileConfiguration config, String type) {
        return HandyPermissionUtil.getDoubleNumber(player, config, type, ">");
    }

    public static int getIntNumber(Player player, FileConfiguration config, String type) {
        return HandyPermissionUtil.getDoubleNumber(player, config, type).intValue();
    }

    public static long getLongNumber(Player player, FileConfiguration config, String type) {
        return HandyPermissionUtil.getDoubleNumber(player, config, type).longValue();
    }

    public static Double getReverseDoubleNumber(Player player, FileConfiguration config, String type) {
        return HandyPermissionUtil.getDoubleNumber(player, config, type, "<");
    }

    public static int getReverseIntNumber(Player player, FileConfiguration config, String type) {
        return HandyPermissionUtil.getReverseDoubleNumber(player, config, type).intValue();
    }

    public static long getReverseLongNumber(Player player, FileConfiguration config, String type) {
        return HandyPermissionUtil.getReverseDoubleNumber(player, config, type).longValue();
    }

    private static Double getDoubleNumber(Player player, FileConfiguration config, String type, String operator) {
        double defaultNumber = config.getDouble(type + ".default", 1.0);
        ConfigurationSection configurationSection = config.getConfigurationSection(type);
        if (configurationSection == null) {
            return defaultNumber;
        }
        Map values = configurationSection.getValues(false);
        for (String key : values.keySet()) {
            if (!player.hasPermission(InitApi.PLUGIN.getName() + "." + type + "." + key)) continue;
            double number = config.getDouble(type + "." + key);
            defaultNumber = ">".equals(operator) ? Math.max(number, defaultNumber) : Math.min(number, defaultNumber);
        }
        return defaultNumber;
    }
}

