/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.event.PlayerTaskScheduleEvent;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.util.ItemStackUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class PlayerFishEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!PlayerFishEvent.State.CAUGHT_FISH.equals((Object)event.getState())) {
            return;
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        Item item = (Item)event.getCaught();
        ItemStack fishItemStack = item.getItemStack();
        Player player = event.getPlayer();
        String content = ItemStackUtil.itemStackSerialize(fishItemStack);
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTaskScheduleEvent(player, DemandTypeEnum.FISH.getType(), fishItemStack.getAmount(), content));
    }
}

