/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskReelPlayerDemand;
import com.handy.playertask.lib.db.Db;
import java.util.List;
import java.util.UUID;

public class TaskReelPlayerDemandService {
    private TaskReelPlayerDemandService() {
    }

    public static TaskReelPlayerDemandService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(TaskReelPlayerDemand taskNpcPlayerDemand) {
        return Db.use(TaskReelPlayerDemand.class).execution().insert(taskNpcPlayerDemand);
    }

    public void batchAdd(List<TaskReelPlayerDemand> taskNpcPlayerDemandList) {
        Db.use(TaskReelPlayerDemand.class).execution().insertBatch(taskNpcPlayerDemandList);
    }

    public List<TaskReelPlayerDemand> findByReelId(Integer reelId) {
        Db<TaskReelPlayerDemand> db = Db.use(TaskReelPlayerDemand.class);
        db.where().eq(TaskReelPlayerDemand::getReelId, reelId);
        return db.execution().list();
    }

    public boolean updateCompletionAmount(Integer id, Integer completionAmount) {
        Db<TaskReelPlayerDemand> db = Db.use(TaskReelPlayerDemand.class);
        db.update().add(TaskReelPlayerDemand::getCompletionAmount, TaskReelPlayerDemand::getCompletionAmount, completionAmount);
        return db.execution().updateById(id) > 0;
    }

    public boolean deleteById(Integer id) {
        Db<TaskReelPlayerDemand> db = Db.use(TaskReelPlayerDemand.class);
        return db.execution().deleteById(id) > 0;
    }

    public void deleteByReelId(Integer reelId) {
        Db<TaskReelPlayerDemand> db = Db.use(TaskReelPlayerDemand.class);
        db.where().eq(TaskReelPlayerDemand::getReelId, reelId);
        db.execution().delete();
    }

    public List<TaskReelPlayerDemand> findByPlayerAndContent(UUID playerUuid, String content, String demandType) {
        Db<TaskReelPlayerDemand> use = Db.use(TaskReelPlayerDemand.class);
        use.where().eq(TaskReelPlayerDemand::getPlayerUuid, playerUuid).eq(TaskReelPlayerDemand::getItemStack, content).eq(TaskReelPlayerDemand::getType, demandType).lt(TaskReelPlayerDemand::getCompletionAmount, TaskReelPlayerDemand::getAmount);
        return use.execution().list();
    }

    public boolean findCountByReelId(Integer reelId) {
        Db<TaskReelPlayerDemand> use = Db.use(TaskReelPlayerDemand.class);
        use.where().eq(TaskReelPlayerDemand::getReelId, reelId).lt(TaskReelPlayerDemand::getCompletionAmount, TaskReelPlayerDemand::getAmount);
        return use.execution().count() > 0;
    }

    private static class SingletonHolder {
        private static final TaskReelPlayerDemandService INSTANCE = new TaskReelPlayerDemandService();

        private SingletonHolder() {
        }
    }
}

