/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.hook.PlayerPointsUtil;
import com.handy.playertitle.hook.VaultUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShopGui {
    private static final ShopGui INSTANCE = new ShopGui();

    private ShopGui() {
    }

    public static ShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.SHOP_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(BuyTypeEnum.ALL.getBuyType());
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        String searchType = handyInventory.getSearchType();
        String playerVault = String.valueOf(VaultUtil.getPlayerVault(player));
        String playerPoints = String.valueOf(PlayerPointsUtil.getPlayerPoints(player));
        String titleCoin = TitleUtil.getTitleCoin(player);
        List<Integer> playerTitleId = TitlePlayerService.getInstance().findTitleIdByPlayerName(player.getName());
        String indexListStr = ConfigUtil.SHOP_CONFIG.getString("shop.index");
        List<Integer> indexList = StrUtil.strToIntList(indexListStr);
        handyInventory.setPageSize(indexList.size());
        Page<TitleList> page = TitleListService.getInstance().findPage(playerTitleId, handyInventory.getPageNum(), handyInventory.getPageSize(), false, BuyTypeEnum.ALL.getBuyType().equalsIgnoreCase(searchType) ? null : searchType);
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String material = ConfigUtil.SHOP_CONFIG.getString("shop.material");
        boolean isEnchant = ConfigUtil.SHOP_CONFIG.getBoolean("shop.isEnchant");
        int customModelDataId = ConfigUtil.SHOP_CONFIG.getInt("shop.custom-model-data");
        int i = 0;
        for (TitleList titleList : page.getRecords()) {
            String name = ConfigUtil.SHOP_CONFIG.getString("shop.name", "${titleName}");
            List infoLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.info");
            List descriptionLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.description");
            List buffLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.buff");
            List particleLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.particle");
            List priceLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.price");
            List meLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.me");
            List buttonLoreList = ConfigUtil.SHOP_CONFIG.getStringList("shop.lore.button");
            List<String> loreList = new ArrayList<String>(infoLoreList);
            HashMap<String, List<String>> replaceBatchMap = MapUtil.newHashMapWithExpectedSize(3);
            if (StrUtil.isNotEmpty(titleList.getDescription())) {
                replaceBatchMap.put("description", TitleUtil.getDescription(titleList.getDescription()));
                loreList.addAll(descriptionLoreList);
            }
            if (TitleUtil.isHaveBuff(titleList.getTitleBuffs())) {
                replaceBatchMap.put("buff", TitleUtil.getBuff(titleList.getTitleBuffs()));
                loreList.addAll(buffLoreList);
            }
            if (titleList.getTitleParticle() != null) {
                replaceBatchMap.put("particle", TitleUtil.getParticle(titleList.getTitleParticle()));
                loreList.addAll(particleLoreList);
            }
            if (!(BuyTypeEnum.PERMISSION.getBuyType().equals(titleList.getBuyType()) || BuyTypeEnum.ACTIVITY.getBuyType().equals(titleList.getBuyType()) || BuyTypeEnum.NOT.getBuyType().equals(titleList.getBuyType()))) {
                loreList.addAll(priceLoreList);
                loreList.addAll(meLoreList);
            }
            if (!BuyTypeEnum.PERMISSION.getBuyType().equals(titleList.getBuyType()) && !BuyTypeEnum.ACTIVITY.getBuyType().equals(titleList.getBuyType())) {
                loreList.addAll(buttonLoreList);
            }
            Map<String, String> replaceMap = this.getReplaceMap(player, playerVault, playerPoints, titleCoin, titleList);
            loreList = ItemStackUtil.loreReplaceMap(loreList, replaceMap);
            loreList = ItemStackUtil.loreBatchReplaceMap(loreList, replaceBatchMap, BaseUtil.getLangMsg("not"));
            String titleMaterial = ConfigUtil.MATERIAL_CONFIG.getString(titleList.getId().toString(), material);
            int titleCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt(titleList.getId() + "_custom-model-data", customModelDataId);
            String titleName = PlaceholderApiUtil.set(player, titleList.getTitleName());
            loreList = PlaceholderApiUtil.set(player, loreList);
            titleName = name.replace("${titleName}", titleName);
            ItemStack itemStack = ItemStackUtil.getItemStack(titleMaterial, titleName, loreList, isEnchant, titleCustomModelDataId);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, titleList.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "open");
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "titleCustom");
        HandyInventoryUtil.setCustomButton(ConfigUtil.SHOP_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> getReplaceMap(Player player, String vault, String playerPoints, String coin, TitleList titleList) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(9);
        map.put("buyType", BaseUtil.getLangMsg("buyType." + titleList.getBuyType()));
        String titleName = PlaceholderApiUtil.set(player, titleList.getTitleName());
        map.put("titleName", titleName);
        map.put("day", titleList.getDay() != 0 ? titleList.getDay() + BaseUtil.getLangMsg("shop.day") : BaseUtil.getLangMsg("perpetual"));
        map.put("price", "");
        map.put("playerMoney", "");
        map.put("buyButton", ConfigUtil.SHOP_CONFIG.getString("buyButton"));
        String buyNoButton = ConfigUtil.SHOP_CONFIG.getString("buyNoButton");
        int haveCount = TitlePlayerService.getInstance().findCount(titleList.getId());
        map.put("haveCount", String.valueOf(haveCount));
        BuyTypeEnum buyTypeEnum = BuyTypeEnum.getEnumThrow(titleList.getBuyType());
        switch (buyTypeEnum) {
            case VAULT: {
                map.put("price", titleList.getAmount().toString());
                map.put("playerMoney", vault);
                if (!(Double.parseDouble(vault) < (double)titleList.getAmount().intValue())) break;
                map.put("buyButton", buyNoButton);
                break;
            }
            case PLAYER_POINTS: {
                map.put("price", titleList.getAmount().toString());
                map.put("playerMoney", playerPoints);
                if (Integer.parseInt(playerPoints) >= titleList.getAmount()) break;
                map.put("buyButton", buyNoButton);
                break;
            }
            case COIN: {
                map.put("price", titleList.getAmount().toString());
                map.put("playerMoney", coin);
                if (Long.parseLong(coin) >= (long)titleList.getAmount().intValue()) break;
                map.put("buyButton", buyNoButton);
                break;
            }
            case ITEM_STACK: {
                ItemStack[] contents;
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleList.getItemStack());
                map.put("buyType", BaseUtil.getDisplayName(ItemStackUtil.getItemMeta(itemStack).getDisplayName(), itemStack.getType().toString()));
                map.put("price", titleList.getAmount().toString());
                int number = 0;
                for (ItemStack item : contents = player.getInventory().getContents()) {
                    if (item == null || Material.AIR.equals((Object)item.getType()) || !item.isSimilar(itemStack)) continue;
                    number += item.getAmount();
                }
                map.put("playerMoney", Integer.toString(number));
                if (number >= titleList.getAmount()) break;
                map.put("buyButton", buyNoButton);
                break;
            }
            case ACTIVITY: {
                map.put("buyButton", buyNoButton);
                break;
            }
        }
        return map;
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", BaseUtil.getLangMsg("buyType." + searchType));
        map.put("nextType", BaseUtil.getLangMsg("buyType." + BuyTypeEnum.getNextEnum(searchType)));
        return map;
    }
}

