/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.db;

import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.SqlManagerUtil;
import com.handy.playertitle.lib.db.enums.SqlKeyword;
import com.handy.playertitle.lib.db.param.FieldInfoParam;
import com.handy.playertitle.lib.db.param.TableInfoParam;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class DbSql
implements Serializable {
    private static final long serialVersionUID = 8696707404811115903L;
    private String tableName;
    private TableInfoParam tableInfoParam;
    private String field;
    private LinkedHashMap<String, FieldInfoParam> fieldInfoMap;
    private String where;
    private List<String> updatefieldList;
    private LinkedHashMap<Integer, Object> updateFieldMap;
    private String limit;
    private String order;
    private String group;

    private static String assemblySql(String ... sqlColl) {
        StringBuilder sb = new StringBuilder();
        for (String sql : sqlColl) {
            if (StrUtil.isEmpty(sql)) continue;
            sb.append(sql);
        }
        return sb.toString();
    }

    protected String selectCountSql(String field) {
        String countStr = StrUtil.isNotEmpty(field) ? String.format("COUNT(DISTINCT `%s`)", field) : "COUNT(*)";
        return DbSql.assemblySql("SELECT ", countStr, " FROM ", this.tableName, this.where);
    }

    protected String selectDataSql() {
        return DbSql.assemblySql("SELECT ", this.field, " FROM ", this.tableName, this.where, this.group, this.order, this.limit);
    }

    protected String insertDataSql() {
        ArrayList<String> questionMarkList = new ArrayList<String>();
        for (int i = 0; i < this.fieldInfoMap.size(); ++i) {
            questionMarkList.add("?");
        }
        return DbSql.assemblySql("INSERT INTO ", this.tableName, "(", this.field, ")", " VALUES ", "(", CollUtil.listToStr(questionMarkList), ")");
    }

    protected String updateDataSql() {
        return DbSql.assemblySql("UPDATE ", this.tableName, " SET ", CollUtil.listToStr(this.updatefieldList), this.where);
    }

    protected String deleteDataSql() {
        return DbSql.assemblySql("DELETE FROM ", this.tableName, this.where);
    }

    protected void addCondition(boolean condition, String fieldName, SqlKeyword sqlKeyword, Object val) {
        if (!condition) {
            return;
        }
        val = this.specialHandling(val);
        this.where = this.where + SqlKeyword.AND.getKeyword() + "`" + fieldName + "`" + sqlKeyword.getKeyword() + "'" + val + "'";
    }

    protected void addCondition(boolean condition, String fieldName, SqlKeyword sqlKeyword, String compareFieldName) {
        if (!condition) {
            return;
        }
        this.where = this.where + SqlKeyword.AND.getKeyword() + "`" + fieldName + "`" + sqlKeyword.getKeyword() + "`" + compareFieldName + "`";
    }

    protected void addNull(boolean condition, String fieldName, SqlKeyword orderType) {
        if (!condition) {
            return;
        }
        this.where = this.where + SqlKeyword.AND.getKeyword() + "`" + fieldName + "`" + orderType.getKeyword();
    }

    protected void addCondition(boolean condition, String fieldName, Object val, SqlKeyword sqlKeyword, String compareFieldName) {
        if (!condition) {
            return;
        }
        this.where = this.where + SqlKeyword.AND.getKeyword() + "`" + fieldName + "`" + " + " + "'" + val + "'" + sqlKeyword.getKeyword() + "`" + compareFieldName + "`";
    }

    protected void addOrderByCondition(boolean condition, String fieldName, SqlKeyword orderType) {
        if (!condition) {
            return;
        }
        this.order = SqlKeyword.ORDER_BY.getKeyword() + "`" + fieldName + "`" + orderType.getKeyword();
    }

    protected void addOrderByCondition(boolean condition, String fieldName, String fieldNameTwo, SqlKeyword orderType) {
        if (!condition) {
            return;
        }
        this.order = SqlKeyword.ORDER_BY.getKeyword() + "`" + fieldName + "`" + orderType.getKeyword() + " , " + "`" + fieldNameTwo + "`" + orderType.getKeyword();
    }

    protected void addOrderByRand(boolean condition) {
        if (!condition) {
            return;
        }
        this.order = "SQLite".equalsIgnoreCase(SqlManagerUtil.getInstance().getStorageMethod()) ? " ORDER BY RANDOM()" : " ORDER BY RAND()";
    }

    protected void addGroupByCondition(boolean condition, String fieldName) {
        if (!condition) {
            return;
        }
        this.group = SqlKeyword.GROUP_BY.getKeyword() + "`" + fieldName + "`";
    }

    protected void addLimitCondition(boolean condition, int pageNo, int pageSize) {
        if (!condition) {
            return;
        }
        int ret = (pageNo - 1) * pageSize;
        int offset = Math.max(ret, 0);
        this.limit = SqlKeyword.LIMIT.getKeyword() + pageSize + SqlKeyword.OFFSET.getKeyword() + offset;
    }

    protected void addInCondition(boolean condition, String fieldName, SqlKeyword sqlKeyword, List<?> in) {
        if (!condition || CollUtil.isEmpty(in)) {
            return;
        }
        ArrayList<String> ins = new ArrayList<String>();
        for (Object obj : in) {
            ins.add("'" + obj + "'");
        }
        this.where = this.where + SqlKeyword.AND.getKeyword() + "`" + fieldName + "`" + sqlKeyword.getKeyword() + "(" + CollUtil.listToStr(ins) + ")";
    }

    protected void updateCondition(boolean condition, String fieldName, Object val) {
        if (!condition) {
            return;
        }
        val = this.updateSpecialHandling(val);
        this.updatefieldList.add("`" + fieldName + "`" + " = " + "?");
        this.updateFieldMap.put(this.updatefieldList.size(), val);
    }

    protected void updateCondition(boolean condition, String fieldName, String calculateFieldName, String sqlKeyword, Object val) {
        if (!condition) {
            return;
        }
        this.updatefieldList.add("`" + fieldName + "`" + " = " + "`" + calculateFieldName + "`" + sqlKeyword + "?");
        this.updateFieldMap.put(this.updatefieldList.size(), val);
    }

    private Object specialHandling(Object val) {
        Date date;
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            val = bool != false ? 1 : 0;
        }
        if ("SQLite".equalsIgnoreCase(SqlManagerUtil.getInstance().getStorageMethod())) {
            if (val instanceof String) {
                val = this.sqliteEscape(val.toString());
            }
            if (val instanceof LocalDateTime) {
                val = DateUtil.toEpochSecond((LocalDateTime)val);
            }
            if (val instanceof Date) {
                date = (Date)val;
                val = date.getTime();
            }
        } else {
            if (val instanceof String) {
                String str = val.toString();
                if (str.contains("'")) {
                    val = str.replace("'", "\\'");
                }
                if (str.contains("\\")) {
                    val = str.replace("\\", "\\\\");
                }
            }
            if (val instanceof LocalDateTime) {
                val = new Timestamp(DateUtil.toEpochSecond((LocalDateTime)val));
            }
            if (val instanceof Date) {
                date = (Date)val;
                val = new Timestamp(date.getTime());
            }
        }
        return val;
    }

    private Object updateSpecialHandling(Object val) {
        Date date;
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            val = bool != false ? 1 : 0;
        }
        if ("SQLite".equalsIgnoreCase(SqlManagerUtil.getInstance().getStorageMethod())) {
            if (val instanceof LocalDateTime) {
                val = DateUtil.toEpochSecond((LocalDateTime)val);
            }
            if (val instanceof Date) {
                date = (Date)val;
                val = date.getTime();
            }
        } else {
            if (val instanceof LocalDateTime) {
                val = new Timestamp(DateUtil.toEpochSecond((LocalDateTime)val));
            }
            if (val instanceof Date) {
                date = (Date)val;
                val = new Timestamp(date.getTime());
            }
        }
        return val;
    }

    private String sqliteEscape(String keyWord) {
        keyWord = keyWord.replace("'", "''");
        return keyWord;
    }

    DbSql(String tableName, TableInfoParam tableInfoParam, String field, LinkedHashMap<String, FieldInfoParam> fieldInfoMap, String where, List<String> updatefieldList, LinkedHashMap<Integer, Object> updateFieldMap, String limit, String order, String group) {
        this.tableName = tableName;
        this.tableInfoParam = tableInfoParam;
        this.field = field;
        this.fieldInfoMap = fieldInfoMap;
        this.where = where;
        this.updatefieldList = updatefieldList;
        this.updateFieldMap = updateFieldMap;
        this.limit = limit;
        this.order = order;
        this.group = group;
    }

    public static DbSqlBuilder builder() {
        return new DbSqlBuilder();
    }

    public TableInfoParam getTableInfoParam() {
        return this.tableInfoParam;
    }

    public void setField(String field) {
        this.field = field;
    }

    public LinkedHashMap<String, FieldInfoParam> getFieldInfoMap() {
        return this.fieldInfoMap;
    }

    public LinkedHashMap<Integer, Object> getUpdateFieldMap() {
        return this.updateFieldMap;
    }

    public static class DbSqlBuilder {
        private String tableName;
        private TableInfoParam tableInfoParam;
        private String field;
        private LinkedHashMap<String, FieldInfoParam> fieldInfoMap;
        private String where;
        private List<String> updatefieldList;
        private LinkedHashMap<Integer, Object> updateFieldMap;
        private String limit;
        private String order;
        private String group;

        DbSqlBuilder() {
        }

        public DbSqlBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DbSqlBuilder tableInfoParam(TableInfoParam tableInfoParam) {
            this.tableInfoParam = tableInfoParam;
            return this;
        }

        public DbSqlBuilder field(String field) {
            this.field = field;
            return this;
        }

        public DbSqlBuilder fieldInfoMap(LinkedHashMap<String, FieldInfoParam> fieldInfoMap) {
            this.fieldInfoMap = fieldInfoMap;
            return this;
        }

        public DbSqlBuilder where(String where) {
            this.where = where;
            return this;
        }

        public DbSqlBuilder updatefieldList(List<String> updatefieldList) {
            this.updatefieldList = updatefieldList;
            return this;
        }

        public DbSqlBuilder updateFieldMap(LinkedHashMap<Integer, Object> updateFieldMap) {
            this.updateFieldMap = updateFieldMap;
            return this;
        }

        public DbSqlBuilder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public DbSqlBuilder order(String order) {
            this.order = order;
            return this;
        }

        public DbSqlBuilder group(String group) {
            this.group = group;
            return this;
        }

        public DbSql build() {
            return new DbSql(this.tableName, this.tableInfoParam, this.field, this.fieldInfoMap, this.where, this.updatefieldList, this.updateFieldMap, this.limit, this.order, this.group);
        }

        public String toString() {
            return "DbSql.DbSqlBuilder(tableName=" + this.tableName + ", tableInfoParam=" + this.tableInfoParam + ", field=" + this.field + ", fieldInfoMap=" + this.fieldInfoMap + ", where=" + this.where + ", updatefieldList=" + this.updatefieldList + ", updateFieldMap=" + this.updateFieldMap + ", limit=" + this.limit + ", order=" + this.order + ", group=" + this.group + ")";
        }
    }
}

