/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.inventory.AdminShopGui;
import com.handy.playertitle.lib.annotation.HandyListener;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class AdminShopPlayerChatListener
implements Listener {
    @EventHandler
    public void onChatAdminShop(AsyncPlayerChatEvent event) {
        Map<String, Integer> map = TitleConstants.ADMIN_SHOP_CACHE_MAP.get(event.getPlayer().getUniqueId());
        if (map == null || map.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage();
        event.setCancelled(true);
        Integer titleId = map.get("titleId");
        Integer rawSlot = map.get("clickRawSlot");
        TitleConstants.ADMIN_SHOP_CACHE_MAP.remove(player.getUniqueId());
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            boolean rst = false;
            if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "name")) {
                String titleName = ConfigUtil.CONFIG.getString("prefixBrackets") + message + ConfigUtil.CONFIG.getString("suffixBrackets");
                rst = TitleListService.getInstance().updateName(titleId, titleName);
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg(rst ? "succeedMsg" : "failureMsg"));
            }
            if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "buyType")) {
                BuyTypeEnum buyType = BuyTypeEnum.getEnum(message);
                if (buyType == null) {
                    MessageUtil.sendMessage(player, BaseUtil.getLangMsg("buyTypeFailureMsg") + " " + message);
                    return;
                }
                if (BuyTypeEnum.PERMISSION.getBuyType().equals(buyType.getBuyType())) {
                    MessageUtil.sendMessage(event.getPlayer(), BaseUtil.getLangMsg("typeFailureMsg"));
                }
                if (BuyTypeEnum.ITEM_STACK.getBuyType().equals(buyType.getBuyType())) {
                    ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
                    if (Material.AIR.equals((Object)itemInMainHand.getType())) {
                        MessageUtil.sendMessage(event.getPlayer(), BaseUtil.getLangMsg("noAir"));
                        return;
                    }
                    TitleListService.getInstance().updateItemStack(titleId, ItemStackUtil.itemStackSerialize(itemInMainHand));
                }
                rst = TitleListService.getInstance().updateBuyType(titleId, buyType.getBuyType());
            }
            if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "item")) {
                if (!"yes".equalsIgnoreCase(message)) {
                    MessageUtil.sendMessage(player, BaseUtil.getLangMsg("view.confirmFailureMsg"));
                    return;
                }
                ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
                if (Material.AIR.equals((Object)itemInMainHand.getType())) {
                    MessageUtil.sendMessage(player, BaseUtil.getLangMsg("noAir"));
                    return;
                }
                rst = TitleListService.getInstance().updateItemStack(titleId, ItemStackUtil.itemStackSerialize(itemInMainHand));
            }
            if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "price")) {
                Integer price = NumberUtil.isNumericToInt(message);
                if (price == null || price < 0) {
                    MessageUtil.sendMessage(player, BaseUtil.getLangMsg("amountFailureMsg"));
                    return;
                }
                rst = TitleListService.getInstance().updateAmount(titleId, price);
            }
            if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "day")) {
                Integer day = NumberUtil.isNumericToInt(message);
                if (day == null || day < 0) {
                    MessageUtil.sendMessage(player, BaseUtil.getLangMsg("amountFailureMsg"));
                    return;
                }
                rst = TitleListService.getInstance().updateDay(titleId, day);
            }
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg(rst ? "succeedMsg" : "failureMsg"));
            if (rst) {
                HandySchedulerUtil.runTask(() -> player.openInventory(AdminShopGui.getInstance().createGui(player, titleId)));
            }
        });
    }
}

