/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.SignUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.Compare;
import com.handy.playertitle.lib.db.Db;
import com.handy.playertitle.lib.db.UpdateCondition;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleMessageUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class TitlePlayerService {
    private TitlePlayerService() {
    }

    public static TitlePlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean set(TitlePlayer titlePlayer) {
        int id;
        Optional<TitlePlayer> titlePlayerOptional = this.findByPlayerNameAndTitleId(titlePlayer.getPlayerName(), titlePlayer.getTitleId());
        if (titlePlayerOptional.isPresent()) {
            TitlePlayer title = titlePlayerOptional.get();
            id = title.getId();
            long expirationTime = title.getExpirationTime().getTime() + (titlePlayer.getExpirationTime().getTime() - System.currentTimeMillis());
            this.updateExpirationTime(title.getId(), new Date(expirationTime));
        } else {
            id = Db.use(TitlePlayer.class).execution().insert(titlePlayer);
        }
        if (id > 0 && ConfigUtil.CONFIG.getBoolean("isAutoUse", false)) {
            TitlePlayerService.getInstance().updateUseByPlayer(titlePlayer.getPlayerName(), false, TitleUseTypeEnum.ALL);
            TitlePlayerService.getInstance().updateUseById(id, true, TitleUseTypeEnum.ALL);
            Optional<Player> playerOptional = BaseUtil.getOnlinePlayer(titlePlayer.getPlayerName());
            playerOptional.ifPresent(player -> TitleUtil.playerTitleUse(player, id, TitleUseTypeEnum.ALL, true));
        }
        return id > 0;
    }

    public void batchAdd(List<TitlePlayer> titlePlayerList) {
        boolean rst = Db.use(TitlePlayer.class).execution().insertBatch(titlePlayerList);
        if (rst) {
            Optional<TitlePlayer> titlePlayerOptional;
            for (TitlePlayer titlePlayer : titlePlayerList) {
                TitleMessageUtil.sendMsg(titlePlayer.getTitleId(), titlePlayer.getTitleName(), titlePlayer.getPlayerName());
            }
            if (ConfigUtil.CONFIG.getBoolean("isAutoUse", false) && (titlePlayerOptional = this.findLastByPlayerName(titlePlayerList.get(0).getPlayerName())).isPresent()) {
                TitlePlayer titlePlayer;
                titlePlayer = titlePlayerOptional.get();
                TitlePlayerService.getInstance().updateUseByPlayer(titlePlayer.getPlayerName(), false, TitleUseTypeEnum.ALL);
                TitlePlayerService.getInstance().updateUseById(titlePlayer.getId(), true, TitleUseTypeEnum.ALL);
                Optional<Player> playerOptional = BaseUtil.getOnlinePlayer(titlePlayer.getPlayerName());
                playerOptional.ifPresent(player -> TitleUtil.playerTitleUse(player, titlePlayer.getId(), TitleUseTypeEnum.ALL, true));
            }
        }
    }

    public void removeById(Integer id) {
        Db.use(TitlePlayer.class).execution().deleteById(id);
    }

    public void removeByTitleId(Integer titleId) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getTitleId, titleId);
        use.execution().delete();
    }

    public boolean removeByTitleIdAndPlayerName(Integer titleId, String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getTitleId, titleId).eq(StrUtil.isNotEmpty(playerName), TitlePlayer::getPlayerName, playerName);
        return use.execution().delete() > 0;
    }

    public boolean removePlayerTitleList(String playerName, List<Integer> titleIds) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().in(TitlePlayer::getTitleId, titleIds).eq(TitlePlayer::getPlayerName, playerName);
        return use.execution().delete() > 0;
    }

    public boolean removePlayerTitle(String playerName, Integer titleId) {
        return this.removePlayerTitleList(playerName, Collections.singletonList(titleId));
    }

    public void removeExpiration(String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().lt(TitlePlayer::getExpirationTime, new Date()).eq(TitlePlayer::getPlayerName, playerName);
        use.execution().delete();
    }

    public List<TitlePlayer> findExpiration(String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().lt(TitlePlayer::getExpirationTime, new Date()).eq(TitlePlayer::getPlayerName, playerName);
        return use.execution().list();
    }

    public void updateUseById(Integer id, Boolean isUse, TitleUseTypeEnum useType) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        UpdateCondition<TitlePlayer> update = use.update();
        switch (useType) {
            case ALL: {
                update.set(TitlePlayer::getIsUseShow, isUse);
                update.set(TitlePlayer::getIsUseBuff, isUse);
                update.set(TitlePlayer::getIsUseParticle, isUse);
                break;
            }
            case SHOW: {
                update.set(TitlePlayer::getIsUseShow, isUse);
                break;
            }
            case BUFF: {
                update.set(TitlePlayer::getIsUseBuff, isUse);
                break;
            }
            case PARTICLE: {
                update.set(TitlePlayer::getIsUseParticle, isUse);
                break;
            }
        }
        use.execution().updateById(id);
    }

    public void updateUseByPlayer(String playerName, Boolean isUse, TitleUseTypeEnum useType) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        UpdateCondition<TitlePlayer> update = use.update();
        switch (useType) {
            case ALL: {
                update.set(TitlePlayer::getIsUseShow, isUse);
                update.set(TitlePlayer::getIsUseBuff, isUse);
                update.set(TitlePlayer::getIsUseParticle, isUse);
                break;
            }
            case SHOW: {
                update.set(TitlePlayer::getIsUseShow, isUse);
                break;
            }
            case BUFF: {
                update.set(TitlePlayer::getIsUseBuff, isUse);
                break;
            }
            case PARTICLE: {
                update.set(TitlePlayer::getIsUseParticle, isUse);
                break;
            }
        }
        use.where().eq(TitlePlayer::getPlayerName, playerName);
        use.execution().update();
    }

    public void updateTitleName(Integer titleId, String titleName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.update().set(TitlePlayer::getTitleName, titleName);
        use.where().eq(TitlePlayer::getTitleId, titleId);
        use.execution().update();
    }

    public void updateExpirationTime(Integer id, Date expirationTime) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.update().set(TitlePlayer::getExpirationTime, expirationTime);
        use.execution().updateById(id);
    }

    public Page<TitlePlayer> findPageByPlayerName(String playerName, Integer pageNum, Integer pageSize) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        Integer oneHundredCount = TitleListService.getInstance().findOneHundredCount();
        use.where().eq(TitlePlayer::getPlayerName, playerName).lt(!SignUtil.isGenuine() && oneHundredCount > 0, TitlePlayer::getTitleId, oneHundredCount).limit(pageNum, pageSize);
        Page<TitlePlayer> page = use.execution().page();
        this.setExtraData(page.getRecords());
        return page;
    }

    private void setExtraData(List<TitlePlayer> titlePlayers) {
        if (CollUtil.isEmpty(titlePlayers)) {
            return;
        }
        List<Integer> titleIds = titlePlayers.stream().map(TitlePlayer::getTitleId).collect(Collectors.toList());
        List<TitleBuff> buffList = TitleBuffService.getInstance().findByTitleIdList(titleIds);
        Map<Integer, List<TitleBuff>> buffMap = buffList.stream().collect(Collectors.groupingBy(TitleBuff::getTitleId));
        List<TitleParticle> titleParticleList = TitleParticleService.getInstance().findByTitleIdList(titleIds);
        Map<Integer, List<TitleParticle>> particleMap = titleParticleList.stream().collect(Collectors.groupingBy(TitleParticle::getTitleId));
        List<TitleList> titleListList = TitleListService.getInstance().findByIds(titleIds);
        Map<Integer, TitleList> titleListMap = titleListList.stream().collect(Collectors.groupingBy(TitleList::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (TitleList)value.get(0))));
        for (TitlePlayer titlePlayer : titlePlayers) {
            TitleList titleList;
            List<TitleParticle> titleParticles;
            List<TitleBuff> titleBuffs = buffMap.get(titlePlayer.getTitleId());
            if (CollUtil.isNotEmpty(titleBuffs)) {
                titlePlayer.getTitleBuffs().addAll(titleBuffs);
            }
            if (CollUtil.isNotEmpty(titleParticles = particleMap.get(titlePlayer.getTitleId()))) {
                titlePlayer.setTitleParticle(titleParticles.get(0));
            }
            if ((titleList = titleListMap.get(titlePlayer.getTitleId())) == null) continue;
            titlePlayer.setDescription(titleList.getDescription());
        }
    }

    public List<Integer> findTitleIdByPlayerName(String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getPlayerName, playerName);
        List<TitlePlayer> titlePlayers = use.execution().list();
        return titlePlayers.stream().map(TitlePlayer::getTitleId).collect(Collectors.toList());
    }

    public Optional<TitlePlayer> findByPlayerNameAndUseType(String playerName, TitleUseTypeEnum useType) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        Compare<TitlePlayer> where = use.where();
        where.eq(TitlePlayer::getPlayerName, playerName);
        switch (useType) {
            case SHOW: {
                where.eq(TitlePlayer::getIsUseShow, true);
                break;
            }
            case BUFF: {
                where.eq(TitlePlayer::getIsUseBuff, true);
                break;
            }
            case PARTICLE: {
                where.eq(TitlePlayer::getIsUseParticle, true);
                break;
            }
        }
        Optional<TitlePlayer> titlePlayerOptional = use.execution().selectOne();
        if (titlePlayerOptional.isPresent()) {
            TitlePlayer titlePlayer = titlePlayerOptional.get();
            List<TitleBuff> titleBuffs = TitleBuffService.getInstance().findByTitleId(titlePlayer.getTitleId());
            titlePlayer.setTitleBuffs(titleBuffs);
            Optional<TitleParticle> titleParticleOptional = TitleParticleService.getInstance().findByTitleId(titlePlayer.getTitleId());
            titleParticleOptional.ifPresent(titlePlayer::setTitleParticle);
            Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titlePlayer.getTitleId());
            titleListOptional.ifPresent(titleList -> titlePlayer.setDescription(titleList.getDescription()));
        }
        return titlePlayerOptional;
    }

    public Optional<TitlePlayer> findByPlayerNameAndTitleId(String playerName, Integer titleId) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getPlayerName, playerName).eq(TitlePlayer::getTitleId, titleId);
        return use.execution().selectOne();
    }

    public List<TitlePlayer> findByPlayerNameAndTitleIdList(String playerName, List<Integer> titleIdList) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getPlayerName, playerName).in(TitlePlayer::getTitleId, titleIdList);
        return use.execution().list();
    }

    public List<TitlePlayer> findByPlayerName(String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getPlayerName, playerName);
        return use.execution().list();
    }

    public Optional<TitlePlayer> findLastByPlayerName(String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getPlayerName, playerName).orderByDesc(TitlePlayer::getId).limit(1, 1);
        return use.execution().selectOne();
    }

    public List<TitleList> findPermissionByPlayerName(String playerName) {
        List<Integer> titleIds = this.findTitleIdByPlayerName(playerName);
        if (CollUtil.isEmpty(titleIds)) {
            return new ArrayList<TitleList>();
        }
        return TitleListService.getInstance().findByIdsAndBuyType(titleIds, BuyTypeEnum.PERMISSION.getBuyType());
    }

    public List<TitleBuff> findPlayerAllBuff(String playerName) {
        List<Integer> titleIdList = this.findTitleIdByPlayerName(playerName);
        return TitleBuffService.getInstance().findByTitleIdList(titleIdList);
    }

    public Optional<TitlePlayer> findById(Integer id) {
        return Db.use(TitlePlayer.class).execution().selectById(id);
    }

    public void updatePlayerName(Player player) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.update().set(TitlePlayer::getPlayerName, player.getName()).set(TitlePlayer::getPlayerUuid, player.getUniqueId().toString());
        use.where().eq(TitlePlayer::getPlayerName, player.getName().toLowerCase()).isNull(TitlePlayer::getPlayerUuid);
        use.execution().update();
    }

    public List<TitlePlayer> findAll() {
        return Db.use(TitlePlayer.class).execution().list();
    }

    public int findCount() {
        return Db.use(TitlePlayer.class).execution().count();
    }

    public int findCount(String playerName) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getPlayerName, playerName);
        return use.execution().count();
    }

    public int findCount(Integer titleId) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getTitleId, titleId);
        return use.execution().count();
    }

    public Page<TitlePlayer> pageByTitleId(Integer titleId, Integer pageNum, Integer pageSize) {
        Db<TitlePlayer> use = Db.use(TitlePlayer.class);
        use.where().eq(TitlePlayer::getTitleId, titleId).limit(pageNum, pageSize);
        return use.execution().page();
    }

    public void removeAll() {
        Db.use(TitlePlayer.class).execution().delete();
    }

    private static class SingletonHolder {
        private static final TitlePlayerService INSTANCE = new TitlePlayerService();

        private SingletonHolder() {
        }
    }
}

