/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.entity.TitleReward;
import com.handy.playertitle.lib.db.Db;
import com.handy.playertitle.lib.db.enter.Page;
import java.util.List;
import java.util.Optional;

public class TitleRewardService {
    private TitleRewardService() {
    }

    public static TitleRewardService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Boolean add(TitleReward titleReward) {
        return Db.use(TitleReward.class).execution().insert(titleReward) > 0;
    }

    public Page<TitleReward> findPage(Integer pageNum, Integer pageSize) {
        Db<TitleReward> use = Db.use(TitleReward.class);
        use.where().limit(pageNum, pageSize).orderByAsc(TitleReward::getNumber);
        return use.execution().page();
    }

    public List<TitleReward> findAll() {
        return Db.use(TitleReward.class).execution().list();
    }

    public Integer findCount() {
        return Db.use(TitleReward.class).execution().count();
    }

    public Optional<TitleReward> findById(Integer id) {
        return Db.use(TitleReward.class).execution().selectById(id);
    }

    public void removeById(Integer id) {
        Db.use(TitleReward.class).execution().deleteById(id);
    }

    public void removeAll() {
        Db.use(TitleReward.class).execution().delete();
    }

    private static class SingletonHolder {
        private static final TitleRewardService INSTANCE = new TitleRewardService();

        private SingletonHolder() {
        }
    }
}

