/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.command.player;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.lib.command.IHandyCommandEvent;
import cn.handyplus.warp.lib.util.AssertUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.param.OpenParam;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OpenCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "open";
    }

    @Override
    public String permission() {
        return "playerWarp.open";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, final String[] args) {
        final Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        new BukkitRunnable(){

            public void run() {
                String type = WarpTypeEnum.ALL.getType();
                if (args.length > 1) {
                    type = args[1];
                }
                OpenParam openParam = OpenParam.builder().isCollection(false).searchType(type).build();
                Inventory inventory = OpenGui.getInstance().createGui(player, openParam);
                Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

