/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.constants;

import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.service.WarpPlayerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum TabListEnum {
    FIRST(Arrays.asList("reload", "open", "clear", "getIp", "me", "collection", "tp", "view", "convert", "create", "tpId", "createGui"), 0, null, 1),
    OPEN_TWO(WarpTypeEnum.getNotAllList(), 1, "open", 2),
    COLLECTION_TWO(WarpTypeEnum.getNotAllList(), 1, "collection", 2),
    CONVERT_ONE(Arrays.asList("MySQL", "SQLite"), 1, "convert", 2),
    CREATE_ONE(Collections.singletonList(BaseUtil.getLangMsg("tabHelp.playerName")), 1, "create", 2),
    CREATE_TWO(Collections.singletonList(BaseUtil.getLangMsg("tabHelp.warpName")), 1, "create", 3),
    CREATE_THREE(Collections.singletonList(BaseUtil.getLangMsg("tabHelp.time")), 1, "create", 4);

    private final List<String> list;
    private final int befPos;
    private final String bef;
    private final int num;

    public static List<String> returnList(String[] args, int argsLength) {
        List<String> completions = new ArrayList<String>();
        if (argsLength == 2 && "tpId".equalsIgnoreCase(args[0])) {
            return WarpPlayerService.getInstance().listWarpId();
        }
        if (argsLength == 2 && "tp".equalsIgnoreCase(args[0])) {
            return WarpPlayerService.getInstance().listWarpName();
        }
        if (argsLength == 2 && "clear".equalsIgnoreCase(args[0])) {
            return WarpPlayerService.getInstance().listServerName();
        }
        if (argsLength == 3 && "clear".equalsIgnoreCase(args[0])) {
            return WarpPlayerService.getInstance().listWorldName(args[1]);
        }
        for (TabListEnum tabListEnum : TabListEnum.values()) {
            if (tabListEnum.getBefPos() - 1 >= args.length || tabListEnum.getBef() != null && !tabListEnum.getBef().equalsIgnoreCase(args[tabListEnum.getBefPos() - 1]) || tabListEnum.getNum() != argsLength) continue;
            completions = tabListEnum.getList();
        }
        return completions;
    }

    public List<String> getList() {
        return this.list;
    }

    public int getBefPos() {
        return this.befPos;
    }

    public String getBef() {
        return this.bef;
    }

    public int getNum() {
        return this.num;
    }

    private TabListEnum(List<String> list, int befPos, String bef, int num) {
        this.list = list;
        this.befPos = befPos;
        this.bef = bef;
        this.num = num;
    }
}

