/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.enter.WarpCollection;
import cn.handyplus.warp.enter.WarpLikePlayer;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.PlayerPointsUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.service.WarpLikePlayerService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class LikeGui {
    private static final LikeGui INSTANCE = new LikeGui();

    private LikeGui() {
    }

    public static LikeGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id, OpenParam openParam) {
        String title = ConfigUtil.LIKE_CONFIG.getString("title");
        int size = ConfigUtil.LIKE_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.LIKE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        handyInventory.setObj(openParam);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.LIKE.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "one");
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "two");
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "three");
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "four");
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "five");
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "info", this.replaceInfoMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "top", this.replaceTopMap(handyInventory, "top"));
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "collection", this.replaceCollectionMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "stepOn", this.replaceTopMap(handyInventory, "stepOn"));
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "pointTop", this.replaceTopMap(handyInventory, "pointTop"));
        HandyInventoryUtil.setButton(ConfigUtil.LIKE_CONFIG, inventory, "pointStepOn", this.replaceTopMap(handyInventory, "pointStepOn"));
        HandyInventoryUtil.setCustomButton(ConfigUtil.LIKE_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> replaceTopMap(HandyInventory handyInventory, String type) {
        int myPrice;
        Player player = handyInventory.getPlayer();
        Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(handyInventory.getId());
        if (!warpPlayerOptional.isPresent()) {
            return MapUtil.of();
        }
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(4);
        WarpPlayer warpPlayer = warpPlayerOptional.get();
        int price = ConfigUtil.LIKE_CONFIG.getInt(type + ".price", 0);
        replaceMap.put("price", String.valueOf(price));
        if ("pointTop".equals(type) || "pointStepOn".equals(type)) {
            myPrice = PlayerPointsUtil.getPlayerPoints(player);
            replaceMap.put("myPrice", String.valueOf(myPrice));
        } else {
            myPrice = VaultUtil.getPlayerVaultToInt(player);
            replaceMap.put("myPrice", String.valueOf(myPrice));
        }
        String button = ConfigUtil.LIKE_CONFIG.getString("noButton");
        if (myPrice >= price) {
            button = ConfigUtil.LIKE_CONFIG.getString("yesButton");
        }
        replaceMap.put("button", button);
        replaceMap.put("thermal_value", warpPlayer.getThermalValue().toString());
        return replaceMap;
    }

    private Map<String, String> replaceInfoMap(HandyInventory handyInventory) {
        Optional<WarpLikePlayer> warpLikePlayerOptional = WarpLikePlayerService.getInstance().findByWarpIdAndPlayerName(handyInventory.getId(), handyInventory.getPlayer().getName());
        String likeStr = ConfigUtil.LIKE_CONFIG.getString("noLike");
        if (warpLikePlayerOptional.isPresent()) {
            likeStr = warpLikePlayerOptional.get().getLike().toString();
        }
        return MapUtil.of("like", likeStr);
    }

    private Map<String, String> replaceCollectionMap(HandyInventory handyInventory) {
        Optional<WarpCollection> warpCollectionOptional = WarpCollectionService.getInstance().findByPlayerName(handyInventory.getPlayer().getName(), handyInventory.getId());
        String collectionStr = ConfigUtil.LIKE_CONFIG.getString("noCollection");
        if (warpCollectionOptional.isPresent()) {
            collectionStr = ConfigUtil.LIKE_CONFIG.getString("yesCollection");
        }
        return MapUtil.of("collection", collectionStr);
    }
}

