/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.DateUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.db.enter.Page;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.ItemStackUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.service.WarpLikePlayerService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class OpenGui {
    private static final OpenGui INSTANCE = new OpenGui();

    private OpenGui() {
    }

    public static OpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, OpenParam openParam) {
        String title = ConfigUtil.OPEN_CONFIG.getString(openParam.getIsCollection() != false ? "collectionTitle" : "title");
        int size = ConfigUtil.OPEN_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.OPEN.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setObj(openParam);
        handyInventory.setSearchType(openParam.getSearchType());
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.OPEN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        OpenParam openParam = (OpenParam)handyInventory.getObj();
        ArrayList<Integer> collectionIds = new ArrayList();
        if (openParam.getIsCollection().booleanValue() && CollUtil.isEmpty(collectionIds = WarpCollectionService.getInstance().findByPlayerName(player.getName()))) {
            return;
        }
        String guiIndexStr = ConfigUtil.OPEN_CONFIG.getString("warp.index", "20,21,22,23,24,29,30,31,32,33");
        List<Integer> guiIndexList = StrUtil.strToIntList(guiIndexStr);
        handyInventory.setPageSize(guiIndexList.size());
        Page<WarpPlayer> page = WarpPlayerService.getInstance().page(handyInventory.getPageNum(), guiIndexList.size(), handyInventory.getSearchType(), collectionIds);
        handyInventory.setPageCount(page.getTotal());
        List<WarpPlayer> records = page.getRecords();
        if (CollUtil.isEmpty(records)) {
            return;
        }
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        for (WarpPlayer warpPlayer : records) {
            ItemStack warpItem = this.getWarpItem(player, warpPlayer);
            itemStackMap.put(warpPlayer.getId(), warpItem);
        }
        int i = 0;
        for (Integer id : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(id));
            map.put(index, id);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "create");
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "me");
        OpenParam openParam = (OpenParam)handyInventory.getObj();
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, openParam.getIsCollection() != false ? "all" : "collection");
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setCustomButton(ConfigUtil.OPEN_CONFIG, handyInventory, "custom");
        this.setTopButton(handyInventory);
    }

    private void setTopButton(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "top");
        if (!ConfigUtil.OPEN_CONFIG.getBoolean("top.enable")) {
            return;
        }
        String topIndex = ConfigUtil.OPEN_CONFIG.getString("top.index");
        List<Integer> indexList = StrUtil.strToIntList(topIndex);
        for (Integer index : indexList) {
            map.put(index, -1);
        }
        Map<Integer, WarpPlayer> warpPlayerMap = WarpPlayerService.getInstance().findByTopIndexList(indexList);
        if (warpPlayerMap.isEmpty()) {
            return;
        }
        for (Integer index : warpPlayerMap.keySet()) {
            WarpPlayer warpPlayer = warpPlayerMap.get(index);
            ItemStack warpItem = this.getWarpItem(player, warpPlayer);
            inventory.setItem(index.intValue(), warpItem);
            map.put(index, warpPlayer.getId());
        }
    }

    private ItemStack getWarpItem(Player player, WarpPlayer warpPlayer) {
        String name = ConfigUtil.OPEN_CONFIG.getString("warp.name", "");
        List loreList = ConfigUtil.OPEN_CONFIG.getStringList("warp.lore");
        List<String> newLoreList = new ArrayList<String>();
        String warpName = name.replace("${warp_name}", warpPlayer.getName());
        Map<String, String> replaceMap = this.replaceMap(warpPlayer);
        for (String lore : loreList) {
            for (String str : replaceMap.keySet()) {
                lore = lore.replace("${" + str + "}", replaceMap.get(str));
            }
            newLoreList.add(lore);
        }
        newLoreList = ItemStackUtil.loreBatchReplaceMap(newLoreList, WarpUtil.getDescriptionMap(warpPlayer.getDescription()), "");
        ItemStack itemStack = ItemStackUtil.itemStackDeserialize(warpPlayer.getLogoName());
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.setDisplayName(BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, warpName)));
        itemMeta.setLore(BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, newLoreList)));
        ItemStackUtil.hideAttributes(itemMeta);
        ItemStackUtil.hideEnchant(itemMeta);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        WarpTypeEnum guildSortEnum = WarpTypeEnum.getEnum(searchType);
        WarpTypeEnum nextEnum = WarpTypeEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", WarpTypeEnum.getDesc(guildSortEnum));
        map.put("nextType", WarpTypeEnum.getDesc(nextEnum));
        return map;
    }

    public Map<String, String> replaceMap(WarpPlayer warpPlayer) {
        int i;
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(9);
        replaceMap.put("id", warpPlayer.getId().toString());
        replaceMap.put("name", warpPlayer.getName());
        replaceMap.put("warp_type", WarpTypeEnum.getDesc(warpPlayer.getType()));
        replaceMap.put("time", DateUtil.format(warpPlayer.getCreateTime(), "yyyy-MM-dd"));
        replaceMap.put("player", warpPlayer.getCreator());
        replaceMap.put("price", warpPlayer.getPrice().toString());
        replaceMap.put("tp_number", warpPlayer.getTpNumber().toString());
        replaceMap.put("thermal_value", warpPlayer.getThermalValue().toString());
        replaceMap.put("expiration_time", DateUtil.format(warpPlayer.getExpirationTime(), "yyyy-MM-dd HH:mm:ss"));
        StringBuilder likeStr = new StringBuilder();
        Integer likeNumber = WarpLikePlayerService.getInstance().findLikeByWarpId(warpPlayer.getId());
        String like = ConfigUtil.OPEN_CONFIG.getString("like");
        String dislike = ConfigUtil.OPEN_CONFIG.getString("dislike");
        for (i = 0; i < likeNumber; ++i) {
            likeStr.append(like);
        }
        for (i = 0; i < 5 - likeNumber; ++i) {
            likeStr.append(dislike);
        }
        replaceMap.put("like", likeStr.toString());
        return replaceMap;
    }
}

