/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.hook.PlayerPointsUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class SelectPayGui {
    private static final SelectPayGui INSTANCE = new SelectPayGui();

    private SelectPayGui() {
    }

    public static SelectPayGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, OpenParam openParam, Integer rawSlot, Integer id) {
        String title = ConfigUtil.SELECT_CONFIG.getString("title");
        int size = ConfigUtil.SELECT_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.SELECT_PAY.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setObj(openParam);
        handyInventory.setId(rawSlot);
        handyInventory.setSearchType(String.valueOf(id));
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.SELECT_PAY.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "point", this.replaceMap(player, "point"));
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "vault", this.replaceMap(player, "vault"));
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "payBack");
        HandyInventoryUtil.setCustomButton(ConfigUtil.SELECT_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> replaceMap(Player player, String type) {
        int money;
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(3);
        String yes = ConfigUtil.SELECT_CONFIG.getString("yesButton");
        String button = ConfigUtil.SELECT_CONFIG.getString("noButton");
        int price = ConfigUtil.SELECT_CONFIG.getInt(type + ".price");
        if ("point".equals(type)) {
            int playerPoints;
            money = playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else {
            double playerVault = VaultUtil.getPlayerVault(player);
            money = (int)playerVault;
            if (playerVault >= (double)price) {
                button = yes;
            }
        }
        map.put("price", String.valueOf(price));
        map.put("money", Integer.toString(money));
        map.put("button", button);
        return map;
    }
}

