/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtil {
    public static final String YYYY = "yyyy-MM-dd";
    public static final String YYYY_HH = "yyyy-MM-dd HH:mm:ss";

    private DateUtil() {
    }

    public static Date parse(String str, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String format(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static int getDifferDay(Long dateTime) {
        return (int)((System.currentTimeMillis() - dateTime) / 86400000L);
    }

    public static Date getDate(Integer day) {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        return calendar.getTime();
    }

    public static boolean isPerpetual(Date date) {
        return date.getTime() > 4733481600000L;
    }

    public static Date getToday() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY);
        try {
            date = sdf.parse(sdf.format(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getTodayEnd() {
        return DateUtil.parse(DateUtil.format(DateUtil.getToday(), YYYY) + " 23:59:59", YYYY_HH);
    }

    public static Date getMonday() {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar.setTimeInMillis(DateUtil.getToday().getTime());
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getSunday() {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar.setTimeInMillis(DateUtil.getToday().getTime());
        calendar.set(7, 1);
        return DateUtil.parse(DateUtil.format(calendar.getTime(), YYYY) + " 23:59:59", YYYY_HH);
    }

    public static Integer dayOfWeekEnum(Date date) {
        Integer[] weekDays = new Integer[]{7, 1, 2, 3, 4, 5, 6};
        Calendar calendar = Calendar.getInstance();
        return weekDays[calendar.get(7) - 1];
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static long toEpochSecond(LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long between(Date dateOne, Date dateTwo) {
        return DateUtil.between(dateOne, dateTwo, ChronoUnit.HOURS);
    }

    public static long between(Date dateOne, Date dateTwo, ChronoUnit unit) {
        return unit.between(DateUtil.toLocalDateTime(dateOne), DateUtil.toLocalDateTime(dateTwo));
    }

    public static Date getWeek(Date date, int week) {
        if (++week > 7) {
            week = 1;
        }
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar.setTimeInMillis(date.getTime());
        calendar.set(7, week);
        return calendar.getTime();
    }

    public static Date addDate(Date date, Integer day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth() {
        return DateUtil.toDate(LocalDateTime.now().withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
    }

    public static Date getFirstDayOfMonth(Date date) {
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
    }

    public static Date getLastDayOfMonth() {
        return DateUtil.toDate(LocalDateTime.now().plusMonths(1L).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).plus(-1L, ChronoUnit.MILLIS));
    }

    public static Date getLastDayOfMonth(Date date) {
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusMonths(1L).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS).plus(-1L, ChronoUnit.MILLIS));
    }

    public static Date getMonth(Date date, int month) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setFirstDayOfWeek(2);
        calendar.setTimeInMillis(date.getTime());
        calendar.set(5, month);
        return calendar.getTime();
    }

    public static Date offset(Date date, int field, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, offset);
        return cal.getTime();
    }
}

