/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.inventory.ViewGui;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ViewClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW.getType();
    }

    @Override
    public void rawSlotClick(final HandyInventory handyInventory, InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Integer pageNum = handyInventory.getPageNum();
        final Integer pageCount = handyInventory.getPageCount();
        final Player player = handyInventory.getPlayer();
        final Map<Integer, Integer> map = handyInventory.getIntMap();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "previousPage")) {
                    if (pageNum > 1) {
                        handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                        ViewGui.getInstance().setInventoryDate(handyInventory);
                    }
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "nextPage")) {
                    if (pageNum + 1 <= pageCount) {
                        handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                        ViewGui.getInstance().setInventoryDate(handyInventory);
                    }
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.VIEW_CONFIG, "back")) {
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> ((Player)player).closeInventory());
                    return;
                }
                Integer id = (Integer)map.get(rawSlot);
                if (id == null) {
                    return;
                }
                WarpPlayerService.getInstance().deleteById(id);
                ViewGui.getInstance().setInventoryDate(handyInventory);
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

