/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.inventory.MeGui;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.inventory.SelectGui;
import cn.handyplus.warp.inventory.SelectPayGui;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpSelectClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.SELECT.getType();
    }

    @Override
    public void rawSlotClick(final HandyInventory handyInventory, InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Integer pageNum = handyInventory.getPageNum();
        final Player player = handyInventory.getPlayer();
        final Integer pageCount = handyInventory.getPageCount();
        final Map<Integer, Integer> map = handyInventory.getIntMap();
        final OpenParam openParam = (OpenParam)handyInventory.getObj();
        final Integer selectRawSlot = handyInventory.getId();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "previousPage")) {
                    if (pageNum > 1) {
                        handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                        SelectGui.getInstance().setInventoryDate(handyInventory);
                    }
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "nextPage")) {
                    if (pageNum + 1 <= pageCount) {
                        handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                        SelectGui.getInstance().setInventoryDate(handyInventory);
                    }
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "back")) {
                    Inventory inventory = OpenGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "search")) {
                    WarpTypeEnum nextEnum = WarpTypeEnum.getNextEnum(handyInventory.getSearchType());
                    handyInventory.setSearchType(nextEnum.getType());
                    MeGui.getInstance().setInventoryDate(handyInventory);
                    return;
                }
                Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.SELECT_CONFIG, "custom");
                String command = custom.get(rawSlot);
                if (StrUtil.isNotEmpty(command)) {
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.chat("/" + command.trim()));
                    return;
                }
                Integer id = (Integer)map.get(rawSlot);
                if (id != null) {
                    Inventory inventory = SelectPayGui.getInstance().createGui(player, openParam, selectRawSlot, id);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                }
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

