/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.command.admin;

import cn.handyplus.top.PlayerTop;
import cn.handyplus.top.constants.PlayerTopTypeEnum;
import cn.handyplus.top.hook.HdUtil;
import cn.handyplus.top.lib.command.IHandyCommandEvent;
import cn.handyplus.top.lib.util.AssertUtil;
import cn.handyplus.top.lib.util.BaseUtil;
import cn.handyplus.top.lib.util.MessageUtil;
import cn.handyplus.top.param.PlayerPapiHd;
import cn.handyplus.top.util.ConfigUtil;
import cn.handyplus.top.util.TopTaskUtil;
import cn.handyplus.top.util.TopUtil;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateHdCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "createHd";
    }

    @Override
    public String permission() {
        return "playerTop.createHd";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        AssertUtil.notTrue(!PlayerTop.USE_HOLOGRAPHIC_DISPLAYS && !PlayerTop.USE_CMI, sender, BaseUtil.getMsgNotColor("HolographicDisplaysFailureMsg"));
        Location playerLocation = player.getLocation();
        Location location = new Location(player.getWorld(), playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
        String type = args[1];
        PlayerTopTypeEnum topTypeEnum = PlayerTopTypeEnum.getType(type);
        if (topTypeEnum != null) {
            TopUtil.deleteHd(topTypeEnum.getType());
            PlayerPapiHd playerPapiHd = TopUtil.createHd(topTypeEnum, location);
            if (playerPapiHd == null) {
                return;
            }
            HdUtil.create(playerPapiHd.getTextLineList(), playerPapiHd.getLocation(), playerPapiHd.getMaterial(), playerPapiHd.getCustomModelData());
            return;
        }
        if (PlaceholderAPI.containsPlaceholders((String)type)) {
            type = type.replace("%", "");
            TopUtil.deletePapiHd(type);
            TopUtil.createPapiHd(type, location);
            Optional<PlayerPapiHd> playerPapiHdOptional = TopTaskUtil.getPapiData(type, ConfigUtil.getPapiOneChildMap());
            if (playerPapiHdOptional.isPresent()) {
                PlayerPapiHd playerPapiHd = playerPapiHdOptional.get();
                HdUtil.create(playerPapiHd.getTextLineList(), playerPapiHd.getLocation(), playerPapiHd.getMaterial(), playerPapiHd.getCustomModelData());
            }
            return;
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg") + ":" + type);
    }
}

