/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.lib.db;

import cn.handyplus.top.lib.InitApi;
import cn.handyplus.top.lib.constants.BaseConstants;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.expand.zaxxer.hikari.HikariConfig;
import cn.handyplus.top.lib.expand.zaxxer.hikari.HikariDataSource;
import cn.handyplus.top.lib.util.HandyConfigUtil;
import cn.handyplus.top.lib.util.MessageUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlManagerUtil {
    private static final SqlManagerUtil INSTANCE = new SqlManagerUtil();
    private HikariDataSource ds;

    private SqlManagerUtil() {
    }

    public static SqlManagerUtil getInstance() {
        return INSTANCE;
    }

    public static void enableSql() {
        SqlManagerUtil.enableSql(null);
    }

    public static void enableSql(String storageMethod) {
        BaseConstants.STORAGE_CONFIG = HandyConfigUtil.load("storage.yml");
        SqlManagerUtil.getInstance().close();
        SqlManagerUtil.getInstance().enableTable(storageMethod);
    }

    public void enableTable(String storageMethod) {
        if (StrUtil.isEmpty(storageMethod)) {
            storageMethod = this.getStorageMethod();
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName(InitApi.PLUGIN.getName() + "HikariPool");
        if ("MySQL".equalsIgnoreCase(storageMethod)) {
            String host = BaseConstants.STORAGE_CONFIG.getString("MySQL.Host");
            String database = BaseConstants.STORAGE_CONFIG.getString("MySQL.Database");
            int port = BaseConstants.STORAGE_CONFIG.getInt("MySQL.Port");
            String useSsl = BaseConstants.STORAGE_CONFIG.getString("MySQL.UseSSL");
            String param = BaseConstants.STORAGE_CONFIG.getString("MySQL.param", "");
            String jdbcUrl = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSsl + "&useUnicode=true&characterEncoding=UTF-8&rewriteBatchedStatements=true" + param;
            hikariConfig.setJdbcUrl(jdbcUrl);
            hikariConfig.setUsername(BaseConstants.STORAGE_CONFIG.getString("MySQL.User"));
            hikariConfig.setPassword(BaseConstants.STORAGE_CONFIG.getString("MySQL.Password"));
        } else {
            String jdbcUrl = "jdbc:sqlite:" + InitApi.PLUGIN.getDataFolder().getAbsolutePath() + "/" + InitApi.PLUGIN.getName() + ".db";
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
            hikariConfig.setConnectionTestQuery("SELECT 1");
            hikariConfig.setJdbcUrl(jdbcUrl);
        }
        this.ds = new HikariDataSource(hikariConfig);
    }

    public Connection getConnection(String storageMethod) throws SQLException {
        if (StrUtil.isEmpty(storageMethod)) {
            storageMethod = this.getStorageMethod();
        }
        if (this.ds == null || this.ds.isClosed()) {
            MessageUtil.sendConsoleDebugMessage(" HikariDataSource \u94fe\u63a5\u5f02\u5e38\u5173\u95ed\uff0c\u91cd\u65b0\u6253\u5f00");
            this.enableTable(storageMethod);
        }
        return this.ds.getConnection();
    }

    public void closeSql(Connection conn, PreparedStatement ps, ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public String getStorageMethod() {
        String storageMethod = BaseConstants.STORAGE_CONFIG.getString("storage-method");
        if ("MySQL".equalsIgnoreCase(storageMethod)) {
            return "MySQL";
        }
        return "SQLite";
    }
}

