/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.util;

import cn.handyplus.top.constants.PlayerTopTypeEnum;
import cn.handyplus.top.constants.TopConstants;
import cn.handyplus.top.core.AsyncTask;
import cn.handyplus.top.enter.TopPapiPlayer;
import cn.handyplus.top.hook.HdUtil;
import cn.handyplus.top.lib.core.CollUtil;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.top.lib.util.MessageUtil;
import cn.handyplus.top.param.PlayerPapiHd;
import cn.handyplus.top.service.TopPapiPlayerService;
import cn.handyplus.top.util.ConfigUtil;
import cn.handyplus.top.util.TopUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;

public class TopTaskUtil {
    private static final Semaphore TASK_LOCK = new Semaphore(1);

    public static void init() {
        long period = ConfigUtil.CONFIG.getLong("task", 300L);
        HandySchedulerUtil.runTaskTimerAsynchronously(() -> TopTaskUtil.setToDataToLock(null, true), 20L, period * 20L);
    }

    public static void setToDataToLock(CommandSender sender, boolean isOnline) {
        if (!TASK_LOCK.tryAcquire()) {
            return;
        }
        try {
            if (!TopConstants.IS_INIT) {
                TopConstants.IS_INIT = true;
                List<TopPapiPlayer> topPapiPlayerList = AsyncTask.supplyOfflineAsync(AsyncTask.getOfflineList());
                TopPapiPlayerService.getInstance().replace(topPapiPlayerList);
                return;
            }
            TopTaskUtil.setTopData(sender, isOnline);
        }
        finally {
            TASK_LOCK.release();
        }
    }

    private static void setTopData(CommandSender sender, boolean isOnline) {
        long start = System.currentTimeMillis();
        if (sender != null) {
            MessageUtil.sendMessage(sender, "\u4e00. \u5f00\u59cb\u83b7\u53d6\u6392\u884c\u6570\u636e,\u8bf7\u8010\u5fc3\u7b49\u5f85,\u5f53\u524d\u8fdb\u5ea6: 1/6");
        }
        List<OfflinePlayer> offlinePlayers = isOnline ? AsyncTask.getOnlineList() : AsyncTask.getOfflineList();
        List<TopPapiPlayer> topPapiPlayerList = AsyncTask.supplyOfflineAsync(offlinePlayers);
        if (sender != null) {
            boolean isOp = ConfigUtil.CONFIG.getBoolean("isOp");
            String msg = "\u4e8c. \u540c\u6b65" + offlinePlayers.size() + "\u4f4d\u5728\u7ebf\u73a9\u5bb6\u53d8\u91cf(\u672a\u8fc7\u6ee4OP),\u5df2\u6d88\u8017ms:" + (System.currentTimeMillis() - start) + ",\u5f53\u524d\u8fdb\u5ea6: 2/6";
            if (isOp) {
                msg = "\u4e8c. \u540c\u6b65" + offlinePlayers.size() + "\u4f4d\u5728\u7ebf\u73a9\u5bb6\u53d8\u91cf(\u5df2\u8fc7\u6ee4OP),\u5df2\u6d88\u8017ms:" + (System.currentTimeMillis() - start) + ",\u5f53\u524d\u8fdb\u5ea6: 2/6";
            }
            MessageUtil.sendMessage(sender, msg);
        }
        TopPapiPlayerService.getInstance().replace(topPapiPlayerList);
        if (sender != null) {
            MessageUtil.sendMessage(sender, "\u4e09. \u4fdd\u5b58" + offlinePlayers.size() + "\u4f4d\u5728\u7ebf\u73a9\u5bb6\u6570\u636e,\u5df2\u6d88\u8017ms:" + (System.currentTimeMillis() - start) + ",\u5f53\u524d\u8fdb\u5ea6: 3/6");
        }
        List<PlayerPapiHd> playerPapiHdList = TopTaskUtil.createHd();
        playerPapiHdList.addAll(TopTaskUtil.createPapiHd());
        if (sender != null) {
            MessageUtil.sendMessage(sender, "\u56db. \u83b7\u53d6\u6784\u5efa\u5168\u606f\u56fe\u7684\u6570\u636e,\u5df2\u6d88\u8017ms:" + (System.currentTimeMillis() - start) + ",\u5f53\u524d\u8fdb\u5ea6: 4/6");
        }
        HandySchedulerUtil.runTask(() -> {
            HdUtil.deleteAll();
            if (sender != null) {
                MessageUtil.sendMessage(sender, "\u4e94. \u5220\u9664\u73b0\u6709\u5168\u606f\u56fe,\u5df2\u6d88\u8017ms:" + (System.currentTimeMillis() - start) + ",\u5f53\u524d\u8fdb\u5ea6: 5/6");
            }
            if (CollUtil.isEmpty(playerPapiHdList)) {
                return;
            }
            for (PlayerPapiHd playerPapiHd : playerPapiHdList) {
                HdUtil.create(playerPapiHd.getTextLineList(), playerPapiHd.getLocation(), playerPapiHd.getMaterial(), playerPapiHd.getCustomModelData());
            }
            if (sender != null) {
                MessageUtil.sendMessage(sender, "\u516d. \u5168\u90e8\u6d41\u7a0b\u5b8c\u6210,\u672c\u6b21\u5237\u65b0" + playerPapiHdList.size() + "\u5168\u606f\u56fe\u6392\u884c,\u5df2\u6d88\u8017ms:" + (System.currentTimeMillis() - start) + ",\u5f53\u524d\u8fdb\u5ea6: 6/6");
            }
        });
    }

    private static List<PlayerPapiHd> createHd() {
        Map values = ConfigUtil.HD_CONFIG.getValues(false);
        ArrayList<PlayerPapiHd> playerPapiHdList = new ArrayList<PlayerPapiHd>();
        for (String type : values.keySet()) {
            boolean enable;
            String world;
            MemorySection memorySection = (MemorySection)values.get(type);
            if (memorySection == null || StrUtil.isEmpty(world = memorySection.getString("world", ""))) continue;
            double x = memorySection.getDouble("x");
            double y = memorySection.getDouble("y");
            double z = memorySection.getDouble("z");
            PlayerTopTypeEnum playerTopTypeEnum = PlayerTopTypeEnum.getType(type);
            if (playerTopTypeEnum == null || !(enable = memorySection.getBoolean("enable"))) continue;
            Location location = new Location(Bukkit.getWorld((String)world), x, y, z);
            PlayerPapiHd playerPapiHd = TopUtil.createHd(playerTopTypeEnum, location);
            if (playerPapiHd == null) {
                MessageUtil.sendConsoleMessage(ConfigUtil.LANG_CONFIG.getString("noWorld", "").replace("${world}", world));
                continue;
            }
            playerPapiHdList.add(playerPapiHd);
        }
        return playerPapiHdList;
    }

    private static List<PlayerPapiHd> createPapiHd() {
        Map<String, Object> values = ConfigUtil.getPapiOneChildMap();
        if (values.isEmpty()) {
            return new ArrayList<PlayerPapiHd>();
        }
        ArrayList<PlayerPapiHd> playerPapiHdList = new ArrayList<PlayerPapiHd>();
        for (String type : values.keySet()) {
            Optional<PlayerPapiHd> papiDataOpt = TopTaskUtil.getPapiData(type, values);
            papiDataOpt.ifPresent(playerPapiHdList::add);
        }
        return playerPapiHdList;
    }

    public static Optional<PlayerPapiHd> getPapiData(String type, Map<String, Object> values) {
        List<TopPapiPlayer> topPapiPlayerList;
        MemorySection memorySection = (MemorySection)values.get(type);
        if (memorySection == null) {
            return Optional.empty();
        }
        boolean enable = memorySection.getBoolean("enable");
        if (!enable) {
            return Optional.empty();
        }
        String papi = memorySection.getString("papi", "");
        int line = memorySection.getInt("line", 10);
        String material = memorySection.getString("material", "");
        int customModelData = memorySection.getInt("custom-model-data", 0);
        String title = memorySection.getString("title", "");
        String lore = memorySection.getString("lore", "");
        String world = memorySection.getString("world", "");
        if (StrUtil.isEmpty(world)) {
            return Optional.empty();
        }
        double x = memorySection.getDouble("x");
        double y = memorySection.getDouble("y");
        double z = memorySection.getDouble("z");
        Location location = new Location(Bukkit.getWorld((String)world), x, y, z);
        ArrayList<String> textLineList = new ArrayList<String>();
        if (StrUtil.isNotEmpty(title)) {
            textLineList.add(title);
        }
        if (CollUtil.isNotEmpty(topPapiPlayerList = TopPapiPlayerService.getInstance().page(papi, 1, line))) {
            for (TopPapiPlayer topPapiPlayer : topPapiPlayerList) {
                textLineList.add(TopUtil.getContent(lore, topPapiPlayer));
            }
        }
        return Optional.of(PlayerPapiHd.builder().textLineList(textLineList).location(location).material(material).customModelData(customModelData).build());
    }
}

