/*
 * Decompiled with CFR 0.152.
 */
package org.buhuipofangle.redPacket.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.buhuipofangle.redPacket.Packing;
import org.buhuipofangle.redPacket.entity.ExclusiveRedPacket;
import org.buhuipofangle.redPacket.entity.RedPacket;
import org.buhuipofangle.redPacket.item.Banknotes;
import org.buhuipofangle.redPacket.util.CommandOutput;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RedPacketCommand
implements CommandExecutor {
    public static final List<RedPacket> packets = new ArrayList<RedPacket>();

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (strings.length == 0 || strings.length == 1 && strings[0].equals("help")) {
                this.help((CommandSender)player);
                return true;
            }
            switch (strings[0]) {
                case "send": {
                    if (strings.length == 3 || strings.length == 4) {
                        try {
                            int count = Integer.parseInt(strings[1]);
                            int money = Integer.parseInt(strings[2]);
                            if (count < 0 || count > Bukkit.getOnlinePlayers().size()) {
                                commandSender.sendMessage(CommandOutput.warn("\u7ea2\u5305\u7684\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e 0 \u4e14 \u4e0d\u80fd\u5927\u4e8e \u5728\u7ebf\u73a9\u5bb6\u6570\u91cf\u3002"));
                                return true;
                            }
                            if (money < 0) {
                                commandSender.sendMessage(CommandOutput.warn("\u7ea2\u5305\u7684\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e 0\u3002"));
                                return true;
                            }
                            if (!Packing.getEconomy().has((OfflinePlayer)player, (double)money)) {
                                double balance = Packing.getEconomy().getBalance((OfflinePlayer)player);
                                commandSender.sendMessage(CommandOutput.warn("\u60a8\u6ca1\u7528\u8db3\u591f\u7684\u91d1\u94b1\uff0c\u5f53\u524d\u8d26\u6237\u4f59\u989d\uff1a" + String.valueOf(ChatColor.GREEN) + "$" + String.format("%.2f", balance)));
                                return true;
                            }
                            String title = null;
                            if (strings.length == 4) {
                                title = strings[3];
                                if (title.length() < 4) {
                                    commandSender.sendMessage(CommandOutput.warn("\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e 4 \u4e2a\u5b57\u7b26\u3002"));
                                    return true;
                                }
                                if (title.length() > 12) {
                                    commandSender.sendMessage(CommandOutput.warn("\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e 12 \u4e2a\u5b57\u7b26\u3002"));
                                    return true;
                                }
                            }
                            RedPacket redPacket = new RedPacket(player, title, money, count);
                            packets.add(redPacket);
                        }
                        catch (NumberFormatException e) {
                            commandSender.sendMessage(CommandOutput.warn("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6570\u5b57\u3002"));
                        }
                        break;
                    }
                    this.help((CommandSender)player);
                    break;
                }
                case "sendTo": {
                    if (strings.length != 3) break;
                    String id = strings[1];
                    int money = Integer.parseInt(strings[2]);
                    try {
                        id = strings[1];
                        money = Integer.parseInt(strings[2]);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(CommandOutput.warn("\u8bf7\u8f93\u5165\u6709\u6548\u6570\u5b57\uff01"));
                        this.help((CommandSender)player);
                        return true;
                    }
                    Player target = Bukkit.getPlayer((String)id);
                    if (target == null) {
                        commandSender.sendMessage(CommandOutput.warn("\u73a9\u5bb6\u4e0d\u5b58\u5728\u3002"));
                        return true;
                    }
                    if (target.equals((Object)player)) {
                        commandSender.sendMessage(CommandOutput.warn("\u4e0d\u80fd\u5411\u81ea\u5df1\u53d1\u9001\u7ea2\u5305\u3002"));
                        return true;
                    }
                    if (money < 0) {
                        commandSender.sendMessage(CommandOutput.warn("\u7ea2\u5305\u7684\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e 0\u3002"));
                        return true;
                    }
                    if (!Packing.getEconomy().has((OfflinePlayer)player, (double)money)) {
                        double balance = Packing.getEconomy().getBalance((OfflinePlayer)player);
                        commandSender.sendMessage(CommandOutput.warn("\u60a8\u6ca1\u7528\u8db3\u591f\u7684\u91d1\u94b1\uff0c\u5f53\u524d\u8d26\u6237\u4f59\u989d\uff1a" + String.valueOf(ChatColor.GREEN) + "$" + String.format("%.2f", balance)));
                        return true;
                    }
                    ExclusiveRedPacket redPacket = new ExclusiveRedPacket(player, money, target);
                    packets.add(redPacket);
                    break;
                }
                case "receive": {
                    if (strings.length != 2) break;
                    String id = strings[1];
                    packets.forEach(packet -> {
                        if (packet.getUuid().equals(id)) {
                            packet.receive(player);
                        }
                    });
                    break;
                }
                case "detail": {
                    if (strings.length != 2) break;
                    String id = strings[1];
                    packets.forEach(packet -> {
                        if (packet.getUuid().equals(id)) {
                            player.sendMessage(packet.getDetail());
                        }
                    });
                    break;
                }
                case "tack": {
                    if (strings.length != 3) break;
                    int money = Integer.parseInt(strings[1]);
                    int filed = 100;
                    if (strings[2].equals("\u4e00\u767e\u4e07")) {
                        filed = 1000000;
                    } else if (strings[2].equals("\u4e00\u5343\u4e07")) {
                        filed = 10000000;
                    } else {
                        try {
                            filed = Integer.parseInt(strings[2]);
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(CommandOutput.warn("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9762\u989d\uff01"));
                            this.help((CommandSender)player);
                            return true;
                        }
                    }
                    if (money < filed) {
                        player.sendMessage(CommandOutput.warn("\u4f60\u53d6\u51fa\u7684\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u9762\u989d\u3002"));
                        return true;
                    }
                    if (money < 0) {
                        commandSender.sendMessage(CommandOutput.warn("\u7ea2\u5305\u7684\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e 0\u3002"));
                        return true;
                    }
                    if (!Packing.getEconomy().has((OfflinePlayer)player, (double)money)) {
                        double balance = Packing.getEconomy().getBalance((OfflinePlayer)player);
                        commandSender.sendMessage(CommandOutput.warn("\u60a8\u6ca1\u7528\u8db3\u591f\u7684\u91d1\u94b1\uff0c\u5f53\u524d\u8d26\u6237\u4f59\u989d\uff1a" + String.valueOf(ChatColor.GREEN) + "$" + String.format("%.2f", balance)));
                        return true;
                    }
                    int count = Math.min(64, money / filed);
                    Packing.getEconomy().withdrawPlayer((OfflinePlayer)player, (double)(count * filed));
                    ItemStack item = Banknotes.get(filed);
                    item.setAmount(count);
                    player.getInventory().addItem(new ItemStack[]{item});
                    double balance = Packing.getEconomy().getBalance((OfflinePlayer)player);
                    player.sendMessage(CommandOutput.success("\u6210\u529f\u652f\u51fa\u4e86" + count + "\u5f20" + filed + "\u5143\u7968\u636e,\u6263\u9664\u4e86\u60a8" + count * filed + "\u5143,\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269:" + String.valueOf(ChatColor.GREEN) + "$" + String.format("%.2f", balance)));
                }
            }
        }
        return true;
    }

    private void help(CommandSender sender) {
        sender.sendMessage(CommandOutput.title("\u793c\u54c1\u6307\u4ee4"));
        sender.sendMessage(CommandOutput.item("/red send <\u6570\u91cf> <\u91d1\u989d> <\u6807\u9898>(\u53ef\u9009) - \u53d1\u9001\u4e00\u4e2a\u7ea2\u5305"));
        sender.sendMessage(CommandOutput.item("/red sendTo <\u73a9\u5bb6> <\u91d1\u989d> - \u53d1\u9001\u4e00\u4e2a\u4e13\u5c5e\u7ea2\u5305"));
        sender.sendMessage(CommandOutput.item("/red tack <\u91d1\u989d> <\u9762\u989d>(1 ,5 ,10 ,100 ,1000 ,10000 ,\u4e00\u767e\u4e07 ,\u4e00\u5343\u4e07) - \u53d6\u51fa\u6307\u5b9a\u9762\u989d\u7684\u91d1\u989d(\u5f97\u5230\u6307\u5b9a\u9762\u989d\u7684\u7eb8\u5e01)"));
    }

    static {
        Bukkit.getScheduler().runTaskTimer((Plugin)Packing.getInstance(), () -> packets.removeIf(packet -> {
            if (packet.isExpire()) {
                if (packet.getRemainingMoney() <= 0.0) {
                    return true;
                }
                Packing.getEconomy().depositPlayer(packet.getOwner(), packet.getRemainingMoney());
                if (packet.getOwner().isOnline()) {
                    Bukkit.getPlayer((UUID)packet.getOwner().getUniqueId()).sendMessage(CommandOutput.warn("\u7ea2\u5305\u5df2\u8fc7\u671f\uff0c\u7ea2\u5305\u5269\u4f59" + String.format("%.2f", packet.getRemainingMoney())) + "\u5df2\u9000\u56de\u3002");
                }
                return true;
            }
            return false;
        }), 0L, 1200L);
    }
}

