/*
 * Decompiled with CFR 0.152.
 */
package org.buhuipofangle.redPacket.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.milkbowl.vault.economy.Economy;
import org.buhuipofangle.redPacket.Packing;
import org.buhuipofangle.redPacket.util.CommandOutput;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class RedPacket {
    static final double MIN_AMOUNT = 0.01;
    static final Random random = new Random();
    String uuid;
    UUID owner;
    String title;
    double maxMoney;
    final int maxCount;
    long expire;
    List<UUID> receivers;
    final double[] packets;

    public RedPacket(Player player, String title, double money, int count) {
        this.owner = player.getUniqueId();
        this.title = title == null ? "\u606d\u559c\u53d1\u8d22" : title;
        this.maxMoney = money;
        this.maxCount = count;
        this.expire = System.currentTimeMillis() + 300000L;
        this.receivers = new ArrayList<UUID>();
        this.packets = RedPacket.generateRedPackets(this.maxMoney, count);
        this.uuid = UUID.randomUUID().toString();
        this.getEconomy().withdrawPlayer((OfflinePlayer)player, money);
        this.board();
    }

    public OfflinePlayer getOwner() {
        return Packing.getInstance().getServer().getOfflinePlayer(this.owner);
    }

    public String getTitle() {
        return this.title;
    }

    public Status receive(Player player) {
        if (this.receivers.size() >= this.maxCount) {
            player.sendMessage(CommandOutput.warn("\u8be5\u7ea2\u5305\u5df2\u7ecf\u88ab\u62a2\u5149\u4e86\u3002"));
            return Status.DONE;
        }
        if (this.receivers.contains(player.getUniqueId())) {
            player.sendMessage(CommandOutput.warn("\u60a8\u5df2\u7ecf\u9886\u53d6\u8fc7\u4e86\u3002"));
            return Status.RECEIVED;
        }
        double money = this.getMoney(player);
        this.getEconomy().depositPlayer((OfflinePlayer)player, money);
        player.sendMessage(CommandOutput.success("\u60a8\u62a2\u5230\u4e86" + String.valueOf(ChatColor.GOLD) + money + String.valueOf(ChatColor.GREEN) + "\u5143\uff0c\u5df2\u5b58\u5165\u60a8\u7684\u8d26\u6237\u3002"));
        return Status.SUCCEED;
    }

    protected double getMoney(Player player) {
        int size = this.receivers.size();
        this.receivers.add(player.getUniqueId());
        return this.packets[size];
    }

    public double getRemainingMoney() {
        double value = 0.0;
        for (int i = this.receivers.size() + 1; i < this.packets.length; ++i) {
            value += this.packets[i];
        }
        return value;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() > this.expire;
    }

    private static double[] generateRedPackets(double totalAmount, int count) {
        if (totalAmount <= 0.0 || count <= 0) {
            throw new IllegalArgumentException("\u603b\u91d1\u989d\u548c\u7ea2\u5305\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        if (totalAmount < (double)count * 0.01) {
            throw new IllegalArgumentException("\u603b\u91d1\u989d\u4e0d\u8db3\u4ee5\u5206\u914d\u6700\u5c0f\u7ea2\u5305");
        }
        double[] packets = new double[count];
        double remainingAmount = totalAmount;
        double mean = totalAmount / (double)count;
        double stdDev = mean / 2.0;
        for (int i = 0; i < count - 1; ++i) {
            double amount;
            do {
                amount = random.nextGaussian() * stdDev + mean;
                amount = Math.max(amount, 0.01);
            } while ((amount = Math.min(amount, remainingAmount - (double)(count - i - 1) * 0.01)) <= 0.0 || amount >= remainingAmount);
            packets[i] = (double)Math.round(amount * 100.0) / 100.0;
            remainingAmount -= packets[i];
        }
        packets[count - 1] = (double)Math.round(remainingAmount * 100.0) / 100.0;
        RedPacket.adjustForPrecision(packets, totalAmount);
        return packets;
    }

    private static void adjustForPrecision(double[] packets, double totalAmount) {
        double sum = Arrays.stream(packets).sum();
        double diff = totalAmount - sum;
        if (Math.abs(diff) > 1.0E-4) {
            int maxIndex = 0;
            for (int i = 1; i < packets.length; ++i) {
                if (!(packets[i] > packets[maxIndex])) continue;
                maxIndex = i;
            }
            int n = maxIndex;
            packets[n] = packets[n] + diff;
            packets[maxIndex] = (double)Math.round(packets[maxIndex] * 100.0) / 100.0;
        }
    }

    private void board() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            TextComponent component = (TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[\u7ea2\u5305] ").color((TextColor)NamedTextColor.RED)).append(Component.text((String)"\u73a9\u5bb6 ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)this.getOwner().getName()).color((TextColor)NamedTextColor.AQUA))).append(((TextComponent)((TextComponent)Component.text((String)(" \u53d1\u9001\u4e86\u7ea2\u5305 " + this.getTitle())).color((TextColor)NamedTextColor.GOLD)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u70b9\u51fb\u67e5\u770b\u7ea2\u5305\u8be6\u60c5")))).clickEvent(ClickEvent.runCommand((String)("/red detail " + this.getUuid()))))).append(((TextComponent)Component.text((String)"\u3010\u70b9\u51fb\u9886\u53d6\u3011").color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.runCommand((String)("/red receive " + this.getUuid()))));
            player.sendMessage((Component)component);
        });
    }

    public Economy getEconomy() {
        return Packing.getEconomy();
    }

    public String getUuid() {
        return this.uuid;
    }

    public Component getDetail() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)(String.valueOf(ChatColor.GOLD) + "\u7ea2\u5305\u91d1\u989d\uff1a" + String.valueOf(ChatColor.WHITE) + this.maxMoney + "\n")))).append((Component)Component.text((String)(String.valueOf(ChatColor.GOLD) + "\u7ea2\u5305\u6570\u91cf\uff1a" + String.valueOf(ChatColor.WHITE) + this.receivers.size() + "/" + this.maxCount + "\n")))).append((Component)Component.text((String)(String.valueOf(ChatColor.GOLD) + "\u9886\u53d6\u8fc7\u7684\u73a9\u5bb6\uff1a" + String.valueOf(ChatColor.WHITE) + this.getPlayersName())))).build();
    }

    private String getPlayersName() {
        return this.receivers.stream().map(uuid -> Packing.getInstance().getServer().getOfflinePlayer(uuid).getName()).collect(Collectors.joining(","));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RedPacket redPacket = (RedPacket)object;
        return Objects.equals(this.getUuid(), redPacket.getUuid());
    }

    public int hashCode() {
        return Objects.hash(this.getUuid());
    }

    public static enum Status {
        SUCCEED,
        RECEIVED,
        EXPIRED,
        DONE;

    }
}

