/*
 * Decompiled with CFR 0.152.
 */
package org.buhuipofangle.redPacket.util;

import org.bukkit.ChatColor;
import org.bukkit.Location;

public class CommandOutput {
    public static final ChatColor TITLE_COLOR = ChatColor.GOLD;
    public static final ChatColor ITEM_COLOR = ChatColor.GREEN;
    public static final ChatColor INFO_COLOR = ChatColor.YELLOW;
    public static final ChatColor ERROR_COLOR = ChatColor.RED;
    public static final ChatColor HIGHLIGHT_COLOR = ChatColor.AQUA;

    public static String title(String title) {
        return String.valueOf(TITLE_COLOR) + String.valueOf(ChatColor.BOLD) + title;
    }

    public static String item(String item) {
        return String.valueOf(ITEM_COLOR) + "- " + String.valueOf(INFO_COLOR) + item;
    }

    public static String success(String message) {
        return String.valueOf(ERROR_COLOR) + "[\u7ea2\u5305] " + String.valueOf(ITEM_COLOR) + "\u2713 " + String.valueOf(ITEM_COLOR) + message;
    }

    public static String error(String message) {
        return String.valueOf(ERROR_COLOR) + "[\u7ea2\u5305] " + String.valueOf(ERROR_COLOR) + "\u2717 " + message;
    }

    public static String warn(String message) {
        return String.valueOf(ERROR_COLOR) + "[\u7ea2\u5305] " + String.valueOf(ChatColor.YELLOW) + "\u26a0 " + String.valueOf(ChatColor.GOLD) + message;
    }

    public static String formatLocation(Location location) {
        if (location == null) {
            return String.valueOf(ERROR_COLOR) + "\u672a\u77e5";
        }
        return String.format("%s(\u00a7e%d\u00a77, \u00a7e%d\u00a77, \u00a7e%d\u00a77)", INFO_COLOR, (int)location.getX(), (int)location.getY(), (int)location.getZ());
    }

    public static String padRight(String text, int length) {
        if (text.length() >= length) {
            return text;
        }
        return String.format("%-" + length + "s", text);
    }
}

