/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Material;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class HorseWatcher
extends AbstractHorseWatcher {
    public HorseWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setStyle(Horse.Style.values()[DisguiseUtilities.random.nextInt(Horse.Style.values().length)]);
            this.setColor(Horse.Color.values()[DisguiseUtilities.random.nextInt(Horse.Color.values().length)]);
        }
    }

    public Horse.Color getColor() {
        return Horse.Color.values()[this.getData(MetaIndex.HORSE_COLOR) & 0xFF];
    }

    @RandomDefaultValue
    public void setColor(Horse.Color color) {
        this.setData(MetaIndex.HORSE_COLOR, color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
        this.sendData(MetaIndex.HORSE_COLOR);
    }

    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getData(MetaIndex.HORSE_COLOR) >>> 8];
    }

    @RandomDefaultValue
    public void setStyle(Horse.Style style) {
        this.setData(MetaIndex.HORSE_COLOR, this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
        this.sendData(MetaIndex.HORSE_COLOR);
    }

    public ItemStack getHorseArmor() {
        return this.getEquipment().getChestplate();
    }

    public void setHorseArmor(ItemStack item) {
        this.getEquipment().setChestplate(item);
        if (!NmsVersion.v1_14.isSupported()) {
            int value = 0;
            if (item != null) {
                Material mat = item.getType();
                if (mat == Material.IRON_HORSE_ARMOR) {
                    value = 1;
                } else if (mat == Material.GOLDEN_HORSE_ARMOR) {
                    value = 2;
                } else if (mat == Material.DIAMOND_HORSE_ARMOR) {
                    value = 3;
                }
            }
            this.setData(MetaIndex.HORSE_ARMOR, value);
            this.sendData(MetaIndex.HORSE_ARMOR);
        }
    }
}

