/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Random;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Panda;

@NmsAddedIn(value=NmsVersion.v1_14)
public class PandaWatcher
extends AgeableWatcher {
    public PandaWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setMainGene(Panda.Gene.values()[new Random().nextInt(Panda.Gene.values().length)]);
            this.setHiddenGene(Panda.Gene.values()[new Random().nextInt(Panda.Gene.values().length)]);
        }
    }

    public Panda.Gene getGene() {
        return this.getMainGene();
    }

    @RandomDefaultValue
    public void setGene(Panda.Gene gene) {
        this.setMainGene(gene);
        this.setHiddenGene(gene);
    }

    public Panda.Gene getMainGene() {
        byte id = this.getData(MetaIndex.PANDA_MAIN_GENE);
        for (Panda.Gene gene : Panda.Gene.values()) {
            if (gene.ordinal() != id) continue;
            return gene;
        }
        return Panda.Gene.NORMAL;
    }

    @MethodOnlyUsedBy(value={})
    public void setMainGene(Panda.Gene gene) {
        this.setData(MetaIndex.PANDA_MAIN_GENE, (byte)gene.ordinal());
        this.sendData(MetaIndex.PANDA_MAIN_GENE);
    }

    public Panda.Gene getHiddenGene() {
        byte id = this.getData(MetaIndex.PANDA_HIDDEN_GENE);
        for (Panda.Gene gene : Panda.Gene.values()) {
            if (gene.ordinal() != id) continue;
            return gene;
        }
        return Panda.Gene.NORMAL;
    }

    @MethodOnlyUsedBy(value={})
    public void setHiddenGene(Panda.Gene gene) {
        this.setData(MetaIndex.PANDA_HIDDEN_GENE, (byte)gene.ordinal());
        this.sendData(MetaIndex.PANDA_HIDDEN_GENE);
    }

    public boolean isSneeze() {
        return this.getPandaFlag(2);
    }

    public void setSneeze(boolean value) {
        this.setPandaFlag(2, value);
    }

    public boolean isTumble() {
        return this.getPandaFlag(4);
    }

    public void setTumble(boolean value) {
        this.setPandaFlag(4, value);
    }

    public boolean isSitting() {
        return this.getPandaFlag(8);
    }

    public void setSitting(boolean value) {
        this.setPandaFlag(8, value);
    }

    @Override
    public boolean isUpsideDown() {
        return this.getPandaFlag(16);
    }

    @Override
    public void setUpsideDown(boolean value) {
        this.setPandaFlag(16, value);
    }

    public int getHeadShaking() {
        return this.getHeadShakingTicks();
    }

    public void setHeadShaking(int timeInTicks) {
        this.setData(MetaIndex.PANDA_HEAD_SHAKING, timeInTicks);
        this.sendData(MetaIndex.PANDA_HEAD_SHAKING);
    }

    @Deprecated
    public int getHeadShakingTicks() {
        return this.getData(MetaIndex.PANDA_HEAD_SHAKING);
    }

    private boolean getPandaFlag(int value) {
        return (this.getData(MetaIndex.PANDA_META) & value) != 0;
    }

    private void setPandaFlag(int no, boolean flag) {
        byte b1 = this.getData(MetaIndex.PANDA_META);
        b1 = flag ? (byte)(b1 | no) : (byte)(b1 & ~no);
        this.setData(MetaIndex.PANDA_META, b1);
        this.sendData(MetaIndex.PANDA_META);
    }
}

