/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractVillagerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Villager;

public class VillagerWatcher
extends AbstractVillagerWatcher {
    public VillagerWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setProfession(Villager.Profession.values()[DisguiseUtilities.random.nextInt(Villager.Profession.values().length)]);
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public VillagerData getVillagerData() {
        return this.getData(MetaIndex.VILLAGER_DATA);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setVillagerData(VillagerData villagerData) {
        this.setData(MetaIndex.VILLAGER_DATA, villagerData);
        this.sendData(MetaIndex.VILLAGER_DATA);
    }

    public Villager.Profession getProfession() {
        if (NmsVersion.v1_14.isSupported()) {
            return this.getVillagerData().getProfession();
        }
        return Villager.Profession.values()[this.getData(MetaIndex.VILLAGER_PROFESSION) + 1];
    }

    @RandomDefaultValue
    public void setProfession(Villager.Profession profession) {
        if (NmsVersion.v1_14.isSupported()) {
            this.setVillagerData(new VillagerData(this.getType(), profession, this.getLevel()));
        } else {
            this.setData(MetaIndex.VILLAGER_PROFESSION, profession.ordinal() - 1);
            this.sendData(MetaIndex.VILLAGER_PROFESSION);
        }
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getType() {
        return this.getVillagerData().getType();
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setType(Villager.Type type) {
        this.setVillagerData(new VillagerData(type, this.getProfession(), this.getLevel()));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getBiome() {
        return this.getType();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBiome(Villager.Type type) {
        this.setType(type);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public int getLevel() {
        return this.getVillagerData().getLevel();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setLevel(int level) {
        this.setVillagerData(new VillagerData(this.getType(), this.getProfession(), level));
    }
}

