/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class MineSkinResponse {
    private int id;
    private String idStr;
    private String uuid;
    private String name;
    private SkinVariant variant;
    private SkinData data;
    private double timestamp;
    private int duration;
    @SerializedName(value="account")
    private int accountId;
    private String server;
    @SerializedName(value="private")
    private boolean privateSkin;
    private int views;
    private boolean duplicate;
    private double nextRequest;

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SkinData getData() {
        return this.data;
    }

    public GameProfile getGameProfile() {
        if (this.getData() == null) {
            return null;
        }
        GameProfile profile = new GameProfile(this.getData().getUUID(), StringUtils.stripToNull((String)this.getData().getName()) == null ? "Unknown" : this.getData().getName());
        if (this.getData().getTexture() != null) {
            Property property = new Property("textures", this.getData().getTexture().getValue(), this.getData().getTexture().getSignature());
            profile.getProperties().put((Object)"textures", (Object)property);
        }
        return profile;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public String getUuid() {
        return this.uuid;
    }

    public SkinVariant getVariant() {
        return this.variant;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isPrivateSkin() {
        return this.privateSkin;
    }

    public int getViews() {
        return this.views;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public double getNextRequest() {
        return this.nextRequest;
    }

    public class SkinData {
        private String name;
        private UUID uuid;
        private SkinTexture texture;

        public UUID getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public SkinTexture getTexture() {
            return this.texture;
        }
    }

    public class SkinTexture {
        private String value;
        private String signature;
        private String url;
        private SkinTextureUrls urls;

        public String getValue() {
            return this.value;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getUrl() {
            return this.url;
        }

        public SkinTextureUrls getUrls() {
            return this.urls;
        }
    }

    public static enum SkinVariant {
        UNKNOWN,
        CLASSIC,
        SLIM;

    }

    public class SkinTextureUrls {
        private String skin;
        private String cape;

        public String getSkin() {
            return this.skin;
        }

        public String getCape() {
            return this.cape;
        }
    }
}

