/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts;

import io.lumine.artifacts.clocks.MythicArtifactsAsyncClock;
import io.lumine.artifacts.commands.BaseCommand;
import io.lumine.artifacts.enchants.EnchantManager;
import io.lumine.artifacts.io.ConfigManager;
import io.lumine.artifacts.items.ItemManager;
import io.lumine.artifacts.metrics.bStats;
import io.lumine.artifacts.profiles.ProfileManager;
import io.lumine.artifacts.skills.SkillManager;
import io.lumine.artifacts.skills.conditions.EnchantLevelCondition;
import io.lumine.artifacts.skills.conditions.EquipSlotCondition;
import io.lumine.artifacts.skills.conditions.ItemAmmoCondition;
import io.lumine.artifacts.skills.mechanics.AmmoLoadMechanic;
import io.lumine.artifacts.skills.mechanics.ConsumeUsedDurabilityMechanic;
import io.lumine.artifacts.skills.mechanics.ConsumeUsedItemMechanic;
import io.lumine.artifacts.skills.mechanics.ParseEquipmentMechanic;
import io.lumine.artifacts.skills.mechanics.ParseWeaponMechanic;
import io.lumine.artifacts.skills.mechanics.SetModelMechanic;
import io.lumine.artifacts.skills.mechanics.SetSlotModelMechanic;
import io.lumine.artifacts.volatilecode.VolatileCodeDisabled;
import io.lumine.artifacts.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicConditionLoadEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Artifacts
extends LuminePlugin
implements Listener {
    private static Artifacts plugin;
    private static MythicMobs core;
    public Logger logger = Logger.getLogger("Minecraft");
    public static Random r;
    private ConfigManager configuration;
    private EnchantManager enchantManager;
    private SkillManager skillManager;
    private ItemManager itemManager;
    private ProfileManager profileManager;
    private VolatileCodeHandler volatileCodeHandler;

    public void load() {
        plugin = this;
    }

    public void enable() {
        core = MythicMobs.inst();
        Log.info((String)(ChatColor.GOLD + "------------------------------------------------"));
        Log.info((String)(ChatColor.AQUA + "+ Loading MythicArtifacts for Bukkit"));
        Log.info((String)(ChatColor.GOLD + "------------------------------------------------"));
        this.configuration = new ConfigManager(this);
        this.bind((AutoCloseable)((Object)this.configuration));
        this.enchantManager = new EnchantManager(this);
        this.skillManager = new SkillManager(this);
        this.itemManager = new ItemManager(this);
        this.profileManager = new ProfileManager(this);
        this.volatileCodeHandler = this.getVolatileCodeHandler();
        this.bind((AutoCloseable)((Object)this.profileManager));
        this.bind((AutoCloseable)((Object)this.enchantManager));
        this.bind((AutoCloseable)((Object)this.skillManager));
        this.bind((AutoCloseable)((Object)this.itemManager));
        this.skillManager.start();
        this.registerCommand("mythicartifacts", (CommandExecutor)new BaseCommand(this));
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)this.profileManager, (Plugin)this);
        manager.registerEvents((Listener)this.itemManager, (Plugin)this);
        this.bind((AutoCloseable)Schedulers.async().runRepeating((Runnable)new MythicArtifactsAsyncClock(), 0L, (long)this.configuration.getClockInterval()));
        this.bind((AutoCloseable)Events.subscribe(MythicMechanicLoadEvent.class).handler(event -> {
            switch (event.getMechanicName().toUpperCase()) {
                case "CONSUMEUSEDDURABILITY": {
                    event.register((SkillMechanic)new ConsumeUsedDurabilityMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                case "CONSUMEUSEDITEM": 
                case "REMOVEUSEDITEM": {
                    event.register((SkillMechanic)new ConsumeUsedItemMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                case "LOADAMMO": 
                case "RELOADAMMO": {
                    event.register((SkillMechanic)new AmmoLoadMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                case "SETMODEL": {
                    event.register((SkillMechanic)new SetModelMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                case "SETSLOTMODEL": {
                    event.register((SkillMechanic)new SetSlotModelMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                case "PARSEWEAPON": 
                case "PARSEWEAPONS": {
                    event.register((SkillMechanic)new ParseWeaponMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                case "PARSEEQUIPMENT": 
                case "PARSEEQUIP": 
                case "PARSEARMOR": {
                    event.register((SkillMechanic)new ParseEquipmentMechanic(event.getMechanicName(), event.getConfig()));
                    break;
                }
                default: {
                    return;
                }
            }
        }));
        this.bind((AutoCloseable)Events.subscribe(MythicConditionLoadEvent.class).handler(event -> {
            switch (event.getConditionName().toUpperCase()) {
                case "ENCHANTLEVEL": 
                case "ENCHANTMENTLEVEL": {
                    event.register((SkillCondition)new EnchantLevelCondition(event.getConditionName(), event.getConfig()));
                    break;
                }
                case "EQUIPSLOT": 
                case "EQUIPMENTSLOT": 
                case "WORNSLOT": {
                    event.register((SkillCondition)new EquipSlotCondition(event.getConditionName(), event.getConfig()));
                    break;
                }
                case "ITEMAMMO": {
                    event.register((SkillCondition)new ItemAmmoCondition(event.getConditionName(), event.getConfig()));
                    break;
                }
                default: {
                    return;
                }
            }
        }));
        new bStats(this);
    }

    public void disable() {
        this.configuration.unload();
    }

    public static Artifacts inst() {
        return plugin;
    }

    public static MythicMobs core() {
        return core;
    }

    public static void log(Level level, String message) {
        plugin.getLogger().log(level, message);
    }

    public static void log(String message) {
        Artifacts.log(Level.INFO, "" + message);
    }

    public static void debug(String message) {
        Artifacts.debug(1, message);
    }

    public static void debug(int level, String message) {
        if (level <= ConfigManager.debugLevel) {
            Artifacts.log(Level.INFO, message);
        }
    }

    public static void error(String message) {
        Artifacts.log(Level.WARNING, message);
    }

    public VolatileCodeHandler getVolatileCodeHandler() {
        if (this.volatileCodeHandler != null) {
            return this.volatileCodeHandler;
        }
        VolatileCodeHandler VCH = new VolatileCodeDisabled();
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (version.equals("craftbukkit")) {
            version = "pre";
        }
        try {
            Class<?> clazz = Class.forName("io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeEnabled_" + version);
            if (VolatileCodeHandler.class.isAssignableFrom(clazz)) {
                VCH = (VolatileCodeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            Artifacts.error("This version of Artifacts is not fully compatible with your version of Bukkit.");
            Artifacts.error("Some features may be limited or disabled until you use a compatible version.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. Volatile code has been disabled.", e);
        }
        return VCH;
    }

    public ConfigManager getConfiguration() {
        return this.configuration;
    }

    public EnchantManager getEnchantManager() {
        return this.enchantManager;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    static {
        r = new Random();
    }
}

